<?php
Wind::import('WIND:mail.sender.IWindSendMail');
/**
 * 使用sendmail发送邮件
 *
 * @author Qian Su <aoxue.1988.su.qian@163.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id$ 
 * @package mail
 * @subpackage sender
 */
class WindSendMail extends WindModule implements IWindSendMail {
	
	/**
	 * @var string sendmail命令路径
	 */
	private $sendMail = '/usr/sbin/sendmail';
	
	/**
	 * @var string 发送者
	 */
	private $sender = '';

	/* (non-PHPdoc)
	 * @see IWindSendMail::send()
	 */
	public function send($mail, $config = array()) {
		$this->_init($config);
		$mailCmd = escapeshellcmd($this->sendMail) . " -oi " . ($this->sender ? "-f " . escapeshellarg($this->sender) . " " : "") . "-t";
		$process = popen($mailCmd, 'w');
		if (!$process) throw new WindMailException(
			'[mail.sender.WindSendMail] send mail fail,can not open the sender process.');
		fputs($process, $mail->createHeader());
		fputs($process, $mail->createBody());
		return pclose($process);
	}

	/**
	 * 初始化系统配置
	 *
	 * @param array $config
	 */
	private function _init($config) {
		parent::setConfig($config);
		$this->sender = $this->getConfig('sender', '', '');
		$this->sendMail = $this->getConfig('sendMail', '', '/usr/sbin/sendmail');
	}
}