<?php
    /**
    * @ This is your website's front controller. Do not edit this file!
    *=================================================================
    */

    /**
    * Set the base path to the application's installation directory
    * @ This also could be used as a flag that you can use in your files
    * @ so they won't be accessible from outside app scope.
    *=================================================================
    */
	define('BASE_PATH', realpath(dirname(__FILE__)).'/');

    /**
    * !! Load required files
    *=================================================
    */
    require BASE_PATH . 'sys/base/Util.php';
    require BASE_PATH . 'sys/core/core.functions.php';
    require BASE_PATH . 'sys/core/core.config.php';

    /**
    * Load the Application class
    *=================================================================
    */
    require BASE_PATH.'sys/base/Application.php';

    /**
    * Set debugging environment
    *=================================================================
    */
    if ( DEBUG ) :
        ini_set('display_errors', 'on');
        error_reporting(-1);
    else :
        ini_set('display_errors', 'off');
        error_reporting(0);
    endif;

    /**
     * Start the Application
     *=================================================================
    */
    Application::start();

    /**
    * Parse url and dispatch the request to the appropriate controller
    *=================================================================
    */
	Application::getFrontController()->dispatch();

/* End of file: index.php */