<?php if ( ! defined('BASE_PATH')) { return; }
/**
* @package      IrisMVC
* @author       Costin Trifan
* @copyright    2010-2011 Costin Trifan <http://irismvc.net/>
* @license      Microsoft Public License (Ms-PL)  http://irismvc.net/license.txt
* @class MySQL
* Database abstraction class for mysql databases
* @uses Sentinel
*/
class MySQL implements IDatabase
{
	/**
	* @private
	* @static
	* Holds the reference to the instance of this classs
	* @type IDatabase object
	*/
	private static $_instance = null;
	/**
	* @protected
	* Holds the reference to the current connection object
	* @type resource
	*/
	protected $con = null;
	/**
	* @protected
	* Holds the database configuration list
	* @type array
	*/
	protected $csArray = array();
	/**
	* @protected
	* Holds the name of the database to connect to.
	* @type string
	*/
	protected $dbName = '';
	/**
	* @protected
	* Holds the tables' prefix
	* @type string
	*/
	protected $prefix = '';
	/**
	* @protected
	* Holds the last query error
	* @type string
	*/
	protected $error = '';
	/**
	* @protected
	* Holds the last executed query
	* @type string
	*/
	protected $query = '';

	/**
	* @public
	* Holds the error message to display to visitors
	* if an error occurres while connecting to database
	* or when running a query against the database.
	* @type string
	*/
	const SERVER_CONNECT_ERROR = 'An error has occurred while trying to connect to database server!';



	/**
	* @private
	* Constructor
	*/
	private function __construct( array $connectionArray )
	{
		$this->csArray = $connectionArray;
		$this->dbName = $this->csArray['database'];
		$this->prefix = $this->csArray['prefix'];
	}

	/**
	* @public
	* @static
	* Retrieve the reference to the instance of this classs
	* @param array The list of parameters to use to connect to the database
	* Valid array keys:
	*	'server'   => 'db server',
	*	'user'     => 'user name',
	*	'password' => 'password',
	*	'database' => 'the database's name',
	*	'prefix'   => 'table prefix'
	* @return IDatabase object
	*/
	public static function getInstance( array $connectionArray )
	{
		if (is_null(self::$_instance) || !(self::$_instance instanceof self))
		{
			self::$_instance = new self($connectionArray);
		}
		return self::$_instance;
	}

	/**
	* @public
	* @throws Exception
	* Set up the connection to database
	* @return boolean true on success otherwise throws exception
	*/
	public function connect( array $dbArray = array() )
	{
		if (empty($dbArray))
		{
			if ($this->isConnected())
			{
				return true;
			}

			$dbArray = $this->csArray;
		}

		$s = $dbArray['server'];
		$u = $dbArray['user'];
		$p = $dbArray['password'];
		$db = $dbArray['database'];
		$px = $dbArray['prefix'];

		$this->dbName = $db;
		$this->prefix = $px;

		$this->con = mysql_connect($s,$u,$p);
		if ( ! $this->con ) {
			$this->_throwError(mysql_error());
		}
		if ( ! mysql_select_db($this->dbName, $this->con) ) {
			$this->_throwError(mysql_error());
		}

		return true;
	}

	/**
	* @public
	* Check to see if there is an open connection to the database server
	* @return boolean
	*/
	public function isConnected()
	{
		return is_resource($this->con);
	}

	/**
	* @public
	* @throws exception if the connection could not be closed
	* Close the current opened connection
	* @return boolean true on success
	*/
	public function disconnect()
	{
		if (is_null($this->con))
		{
			return true;
		}
		if (mysql_close($this->con)) {
			$this->con = null;
			return true;
		}
		else { $this->_throwError(mysql_error()); }
	}

	/**
	* @public
	* Retrieve the last generated error.
	* @return string
	*/
	public function getError()
	{
		return $this->error();
	}

	/**
	* @public
	* Retrieve the currrent/last executed query.
	* @return string
	*/
	public function getQuery()
	{
		return $this->query();
	}

	/**
	* @public
	* Retrieve the tables' prefix.
	* @return string
	*/
	public function getPrefix()
	{
		return $this->prefix();
	}

	/**
	* @public
	* Retrieve the connection object.
	* @return object
	*/
	public function getConnectionObject()
	{
		return $this->con;
	}

	/**
	* @public
	* Retrieve the connection array.
	* @return array
	*/
	public function getConnectionArray()
	{
		return $this->csArray;
	}

	/**
	* @public
	* {GET/SET} the current query
	* @return string | IDatabase object
	*/
	public function query( $query = '' )
	{
		if (empty($query)) {
			return $this->query;
		}
		$this->query = $query;
		return $this;
	}

	/**
	* @public
	* {GET/SET} the error message
	* @return string | IDatabase object
	*/
	public function error( $error = '' )
	{
		if (empty($error)) {
			return $this->error;
		}
		$this->error = $error;
		return $this;
	}

	/**
	* @public
	* {GET/SET} the table prefix
	* @return string | IDatabase object
	*/
	public function prefix( $prefix = '' )
	{
		if (empty($prefix)) {
			return $this->prefix;
		}
		$this->prefix = $prefix;
		return $this;
	}

    /**
	* @public
    * Execute a sql query
	* @param string  The query to execute
	* param bool  Whether or not to return the result of the query
    * @return resource if $returnResult true, else: boolean
    */
    public function run( $query, $returnResult = false )
    {
		$this->query($query);

        if ($returnResult)
        {
            if (false !== ($res = mysql_query($query, $this->con))) {
            	return $res;
			}
			else {
				if (DEBUG) { $this->error(mysql_error()); }
				else { $this->error(self::SERVER_CONNECT_ERROR); }
				return false;
			}
        }
        else {
            if (false !== ($res = mysql_query($query, $this->con))) {
            	return true;
			}
			else {
				if (DEBUG) { $this->error(mysql_error()); }
				else { $this->error(self::SERVER_CONNECT_ERROR); }
				return false;
			}
        }
    }

    /**
	* @public
    * Retrieve the specified number of records from the query
	* @param array  The list of fields to select
	* @param $table  The name of the table
	* @param string  The sql WHERE clause
	* @param array  The sql LIMIT clause. if provided, both values are required. ex: $limit = array(0,5)
    * @return array
    */
    public function get( array $fields, $table, $where = '', array $limit = array() )
    {
		if ( ! empty($limit)) {
			$limit = " LIMIT {$limit[0]},{$limit[1]}";
		}
		else { $limit = ''; }

        $res = array();
        $cols = implode(',' ,$fields);

		if ( ! empty($where)) {
			$where = ' '.$where;
		}

		$query = "SELECT {$cols} FROM ".$this->prefix . $table . $where . $limit;

        $temp = $this->run($query, true);
        if ( ! $temp ) {
        	return $res;
    	}
		$i = 0;
        while($r = mysql_fetch_assoc($temp))
        {
            foreach($fields as $k) {
                $res[$i][$k] = $r[$k];
            }
			$i++;
        }
        return $res;
	}

    /**
	* @public
    * Retrieve all content of a table
	* @param string The name of the table
	* @param string The sql WHERE clause
    * @return array|false
    */
    public function getAll( $table, $where = '' )
    {
		if ( ! empty($where)) {
			$where = ' '.$where;
		}
        $query = "SELECT * FROM " . $this->prefix . $table . $where;

        $arr = array();
        $res = $this->run($query, true);

        if ($res !== false)
        {
            while($rs = mysql_fetch_assoc($res))
            {
                array_push($arr, $rs);
            }
        }

        return $arr;
    }

    /**
	* @public
    * Retrieve the value of the selected column name
	* @param string The name of the column to retrieve from $table
	* @param string The name of the table
	* @param string The sql WHERE clause
    * @return mixed|false
    */
    public function getOne( $field, $table, $where = '' )
    {
        $where = (!empty($where)) ? (" {$where}") : '';
        $query = "SELECT `{$field}` FROM ".$this->prefix . $table . $where. ' LIMIT 0,1';

        if(false !== ($res = $this->run($query, true)))
        {
            $r = mysql_fetch_assoc($res);
            return $r[$field];
        }
        return false;
    }

    /**
	* @public
    * Retrieve the content of an entire row from the database
	* @param string The name of the table
	* @param string The sql WHERE clause
    * @return array|false
    */
    public function getRow( $table, $where = '' )
    {
        $where = (!empty($where)) ? (" {$where}") : '';
        $query = "SELECT * FROM ".$this->prefix . $table . $where. ' LIMIT 0,1';

        if (false !== ($res = $this->run($query, true)))
        {
            return mysql_fetch_assoc($res);
        }
        return false;
    }

    /**
	* @public
    * Retrieve all content of a selct query as an associative array
	* @param string The select query to execute
    * @return array|false
    */
    public function getAllFromQuery( $query )
    {
		$this->query($query);

        $arr = array();
        $res = $this->run($query, true);

        if ($res !== false)
        {
            while($rs = mysql_fetch_assoc($res))
            {
                array_push($arr, $rs);
            }
        }
        return $arr;
    }

    /**
	* @public
    * Retrieve the number of rows return by a mysql query
	* @param string The name of the table
	* @param string The sql WHERE clause
    * @return integer, -1 on error
    */
    public function count( $table, $where = '' )
    {
        $n = -1;
        $all = $this->getAll($table,$where);

        if (false == $all) { return $n; }

        $n = count($all);

        return $n;
    }

    /**
	* @public
    * Retrieve the number of rows return by a mysql query
	* @param string The name of the table
	* @param string The sql WHERE clause
    * @return number, -1 on error
    */
    public function countFromQuery( $query )
    {
        $n = -1;
        $all = $this->getAllFromQuery($query);
        if (false == $all) { return $n; }

        $n = count($all);

        return $n;
    }

	/**
	* @public
	* Execute a stored procedure against the database. Note that the Stored Procedure
	* should return an int (0 or 1).
	* @param string The stored procedure name
	* @param array The list of arguments to pass to the stored procedure
	* @param var The variable that will store the value returned by the stored procedure
	* @return int 0 on error, 1 on success
	*/
	public function executeSP( $spName, array $arguments, $outResult )
	{
		$query = "CALL {$spName}('".implode("','",$arguments)."', {$outResult});";

		$outResult = $this->run($query, true);

		return $outResult;
	}

    /**
	* @public
    * Execute an INSERT INTO command
    * @return boolean
    */
    public function insertInto( $table, $insert_statement = array(/* db_column_name => column_value */) )
    {
        $q = "INSERT INTO ".$this->prefix.$table." (";
        $data = ' VALUES (';

        foreach($insert_statement as $k=>$v)
        {
			$q .= "`{$k}`,";
			$data .= "'{$v}',";
        }

        $query = substr($q, 0, strlen($q)-1) . ')' . substr($data, 0, strlen($data)-1).')';

        return $this->run($query);
    }

    /**
	* @public
    * Execute an UPDATE command
    * @return boolean
    */
    public function update( $table, $update_statement = array(/* db_column_name => column_value */), $where = '' )
    {
         $where = (!empty($where) ? (" {$where}") : '');

        $set = '';
        foreach($update_statement as $k => $v)
        {
            $set .= "`{$k}` = '{$v}',";
        }

        $set = substr($set, 0, strlen($set)-1); /*[ remove last colon ]*/

        $table = $this->prefix . $table;
        $query = "UPDATE {$table} SET {$set} {$where}";

        return $this->run($query);
    }

    /**
	* @public
    * Execute a DELETE command
    * @return boolean
    */
    public function deleteFrom( $table, $where = '' )
    {
        $from = 'FROM '. $this->prefix . $table;
        $where = (!empty($where) ? (" {$where}") : '');

        $query = "DELETE {$from} {$where}";

        return $this->run($query);
    }

	/**
	* @public
	* Retrieve the list of columns and their associated data from a given table as an associative array.
	* @param string The name of the table from where to retrieve the column names
	* @return array
	*/
	public function getColumnsFrom( $table )
	{
		$query = "SHOW COLUMNS FROM ". $this->prefix . $table;

		$res = $this->run($query, true);
		if ($res === false) { return array(); }

		$result = array();
		while ($row = @mysql_fetch_assoc($res)) {
			array_push($result, $row);
		}
		return $result;
	}

	/**
	* @public
	* Retrieve the list of tables from a database as an associative array.
	* @param string The database name from where to retrieve the list of tables
	* @return array
	*/
	public function getTablesFrom( $database = '' )
	{
		if (empty($database)) {
			$database = $this->dbName;
		}
		$query = "SHOW TABLES FROM {$database}";

		$res = $this->run($query, true);
		if ($res === false) { return array(); }

		$result = array();
		while ($row = @mysql_fetch_row($res)) {
			array_push($result, $row[0]);
		}
		return $result;
	}

	/**
	* @public
	* If you have MySQL tables(MYISAM) that grow large and then have a lot of deletes
	* they will become fragmented and larger than they need to be.
	* Use this function to free up the unused space.
	* @param array The list of tables to optimize. Provide an empty array to optimize all tables
	* @return array
	*/
	public function optimizeTables( array $tables = array(), $database = '' )
	{
		$tables = (!empty($tables) ? $tables : $this->getTablesFrom($database));
		$res = array();
		foreach ($tables as $table)
		{
			$table = $this->prefix . $table;
			$query = "OPTIMIZE TABLE {$table}";

			if ($this->run($query))
			{
				$res[$table] = $table. ' has been optimized!';
			}
			else { $res[$table] = $table. ' could not be optimized!'; }

		}
		return $res;
	}

	/**
	* @public
	* Escape a string using the htmlspecialchars function
	* @param string The string to be escaped
	* @return string
	*/
    public function escape( $string )
	{
		return Sentinel::escape($string);
	}

	/**
	* @public
	* Unescape a string using the htmlspecialchars_decode function
	* @param string The string to be unescaped
	* @return string
	*/
    public function unescape( $string )
	{
		return Sentinel::unescape($string);
	}

	/**
	* @public
	* Start a transaction
	* @param boolean Set autocommit on or off. Defaults to off.
	* @return boolean
	*/
	public function startTransaction( $setAutocomit0 = true )
	{
		if ($setAutocomit0) { $this->run("SET AUTOCOMMIT=0"); }
		return $this->run("START TRANSACTION");
	}
	/**
	* @public
	* Commit a transaction
	* @return boolean
	*/
	public function commitTransaction() { return $this->run("COMMIT"); }
	/**
	* @public
	* Rollback a transaction
	* @return boolean
	*/
	public function rollbackTransaction() { return $this->run("ROLLBACK"); }
	/** @  Alias for startTransaction */
	public function start( $setAutocomit0 = true ) { return $this->startTransaction($setAutocomit0); }
	/* @ Alias for commitTransaction */
	public function commit() { return $this->commitTransaction(); }
	/* @ Alias for rollbackTransaction */
	public function rollback() { return $this->run("ROLLBACK"); }

	//@ throw the specified error
	protected function _throwError( $mysql_error )
	{
		if (DEBUG) { $error = $mysql_error; }
		else { $error = self::SERVER_CONNECT_ERROR; }

		$this->error($error);

		throw new Exception( $error );
	}
}