<?php  if ( ! defined('BASE_PATH')) { return; }
/**
* class Crypto
*
* @desc            The Crypto class provides two-way data encryption using the Mcrypt library.
* 		           Inspired from http://www.php.net/manual/en/mcrypt.examples.php#84147
* @package         IrisMVC
* @category        Encryption


* @date            May 02, 2010
* @revision        $1 May 05, 2010
* @revision        $2 Mar 26, 2011
*/
class Crypto
{
	/**
	* @private
	* @desc The 24 bit key
	* @type string
	* @see Key()
	*/
	private $_key = '';
	/**
	* @private
	* @desc The 8 bit initialization vector
	* @type string
	* @see Iv()
	*/
	private $_iv = '';
	/**
	* @private
	* @desc The bit amount for diff algorythm
	* @type integer
	* @see BitCheck()
	*/
	private $_bitCheck = 8;


    /*
	* @public
	* @desc Constructor. Requires the MCrypt library.
    * @throws Exception if the $key size is greater than 24 characters
    * @throws Exception if the $iv size is not exactly 8 characters long
	* @param string The 24 bit key used for encryption
	* @param string The 8 bit initialization vector used for encryption
	* @return void
	*/
    public function __construct( $key, $iv )
    {
		$this->key($key);
		$this->iv($iv);
    }


	/**
	* @public
	* @desc Get/Set the encryption key
	* @param string|null The encryption key to use
	* @throws Exception if key size too large
	* @return string|null
	*/
	public function key( $value = null )
	{
		if (empty($value)) { return $this->_key; }
		$val = strlen($value);
		if (Util::InRange($val, 1, 24)) { $this->_key = $value; }
		else { throw new Exception(__METHOD__.': Key size too large; supplied length: '.$val.', max: 24'); }
	}

	/**
	* @public
	* @desc Get/Set the initialization vector
	* @param string|null The initialization vector to use
	* @throws Exception if iv size incorrect
	* @return string|null
	*/
	public function iv( $value = null )
	{
		if (empty($value)) { return $this->_iv; }
		$val = strlen($value);
		if ($val == 8) { $this->_iv = $value; }
		else { throw new Exception(__METHOD__.': Iv size incorrect; supplied length: '.$val.', needed: 8'); }
	}

	/**
	* @public
	* @desc Get bit amount for diff algorythm
	* @return integer
	*/
	public function bitCheck()
	{
		return $this->_bitCheck;
	}

    /**
	* @public
    * @desc Encrypts the specified text using the triple_des and cbc and stores it in a base64 encoded string
    *
    * @param string  The text to be encrypted
	* @param string The 24 characters string key to use as encryption key. Optional
	* @param string The 8 characters initializition vector. Optional
	* @throws Exception
    * @return string
    */
	public function encrypt( $text, $key = null, $iv = null )
	{
		if (empty($key)) { $key = $this->key(); }
		if (empty($iv)) { $iv = $this->iv(); }

		$bit_check = $this->bitCheck();

		$text_num = str_split($text,$bit_check);
		$text_num = $bit_check - strlen($text_num[count($text_num)-1]);
		for ($i = 0; $i < $text_num; $i++) { $text = $text . chr($text_num); }
		$cipher = mcrypt_module_open(MCRYPT_TRIPLEDES,'','cbc','');
		mcrypt_generic_init($cipher, $key, $iv);
		$decrypted = mcrypt_generic($cipher,$text);
		mcrypt_generic_deinit($cipher);
		return base64_encode($decrypted);
	}

    /**
	* @public
    * @desc Decrypts the specified text
    *
    * @param string  The text to be encrypted
	* @param string The 24 characters string key to use as encryption key. Optional
	* @param string The 8 characters initializition vector. Optional
	* @throws Exception
    * @return string
    */
	public function decrypt( $text, $key = null, $iv = null )
	{
		if (empty($key)) { $key = $this->key(); }
		if (empty($iv)) { $iv = $this->iv(); }

		$bit_check = $this->bitCheck();

		$cipher = mcrypt_module_open(MCRYPT_TRIPLEDES,'','cbc','');
		mcrypt_generic_init($cipher, $key, $iv);
		$decrypted = mdecrypt_generic($cipher,base64_decode($text));
		mcrypt_generic_deinit($cipher);
		$last_char = substr($decrypted,-1);
		for($i = 0; $i < $bit_check - 1; $i++)
		{
			if(chr($i) == $last_char) {
				$decrypted=substr($decrypted,0,strlen($decrypted)-$i);
				break;
			}
		}
		return $decrypted;
	}
}
/* End of file: Crypto.php */