<?php  if ( ! defined('BASE_PATH')) { exit( 'File: '.basename(__FILE__).' was not found!' ); }
/**
* @class IrisPagination
* Provides utility methods to paginate the data resulted from a sql query 
*
* @uses Util, StringBuilder
* 
* @package      IrisMVC
* @author       Costin Trifan
* @copyright    2010-2011 Costin Trifan <http://irismvc.net/>
* @license      Microsoft Public License (Ms-PL)  http://irismvc.net/license.txt
* 
* revision      Mar 21, 2011.
* revision      June 07, 2011.
*/
class IrisPagination
{
	/**
	* @protected
	* @desc Holds the number of records to display on a page
	* @see self::__construct()
	* @type int
	*/
	private $_showPerPage = 10;
	/**
	* @private
	* @desc Holds the total results number returned by the select query
	* @see self::__construct()
	* @type int
	*/
	private $_numResults = 0;
	/**
	* @private
	* @desc Holds the number of the current page
	* @see self::__construct()
	* @type int
	*/
	private $_currentPage = 1;
	/**
	* @private
	* @internal
	* @desc Holds the total pages number
	* @see self::__construct()
	* @type int
	*/
	private $_numPages = 0;
	/**
	* @private
	* @internal
	* @desc Holds the name of the active controller
	* @see self::__construct()
	* @type string
	*/
	private $_controller = '';
	/**
	* @private
	* @internal
	* @desc Holds the name of the active action
	* @see self::__construct()
	* @type string
	*/
	private $_action = '';
	
	
	/**
	 * @public
	 * @desc Constructor
	 * @param int The total number of records.
	 * @param int The current displayed page. Defaults to 1.
	 * @param int The number of results to display per page. Defaults to 10.
	 * @return void
	 */
	public function __construct( $numResults, $currentPage = 1, $showPerPage = 10 )
	{
		$this->_showPerPage = $showPerPage;
		$this->_numResults = $numResults;
		$this->_currentPage = $currentPage;

		$fc = FrontController::getInstance();
		$this->_controller = $fc->getControllerName();
		$this->_action = $fc->getActionName();
		
		$this->_numPages = ceil($this->_numResults / $this->_showPerPage);
		if (!Util::inRange($this->_currentPage, 1,$this->_numPages)) {
			$this->_currentPage = 1;
		}
	}

	/**
	 * @public
	 * @desc Display the pagination with First, Previous, Next and Last links.
	 * @param string $firstPageText  The text to display for the "First" link. Defaults to "First".
	 * @param string $previousPageText The text to display for the "Previous" page link. Defaults to "Previous".
	 * @param string $nextPageText The text to display for the "Next" page link. Defaults to "Next".
	 * @param string $lastPageText The text to display for the "Last" page link. Defaults to "Last".
	 * @return string
	 */
	public function showPrevNext( $firstPageText = 'First', $previousPageText = 'Previous', $nextPageText = 'Next', $lastPageText = 'Last' )
	{
		$prevNum = $this->_currentPage - 1;
		if ($prevNum < 1) { $prevNum = 1; }

		$nextNum = $this->_currentPage + 1;
		if ($nextNum > $this->_numPages) { $nextNum = $this->_numPages; }
		
		$s = new StringBuilder();
		$s->append('<ul>');
			$s->append('<li><a href="'.createPath($this->_controller,$this->_action,array(1)).'" class="page">'.$firstPageText.'</a></li>');
			$s->append('<li><a href="'.createPath($this->_controller,$this->_action,array($prevNum)).'" class="page">'.$previousPageText.'</a></li>');
			$s->append('<li><a href="'.createPath($this->_controller,$this->_action,array($nextNum)).'" class="page">'.$nextPageText.'</a></li>');
			$s->append('<li><a href="'.createPath($this->_controller,$this->_action,array($this->_numPages)).'" class="page">'.$lastPageText.'</a></li>');
			$s->append('</ul>');
		return $s;
	}

	/**
	 * @public
	 * @desc Display the pagination as numbered pages.
	 * @return string 
	 */
	public function showPages()
	{
		$s = new StringBuilder();
		$s->append('<ul>');
			for( $i=1; $i <= $this->_numPages; $i++)
			{
				$s->append('<li><a href="'.createPath($this->_controller,$this->_action,array($i)).'" class="page">'.$i.'</a></li>');
			}
			$s->append('</ul>');
		return $s;
	}
}
/*! End of file: IrisPagination.php !*/