<?php if (!defined('BASE_PATH')) { return; }
/**
* @package      IrisMVC
* @author       Costin Trifan
* @copyright    2010-2011 Costin Trifan <http://irismvc.net/>
* @license      Microsoft Public License (Ms-PL)  http://irismvc.net/license.txt
* @class Application
* Holds all application's settings
*/
class Application
{
	/**
	* @public
	* Holds the framework's version
	* @type float
	*/
    const APP_VERSION = 2.0;
	/**
	* @public
	* Holds the framework's current release status
	* @type string
	*/
    const APP_STATUS = 'RC 1';
	/**
	* @public
	* Holds the framework's code name
	* @type string
	*/
    const APP_CODENAME = 'Phoenix';
	/**
	* @public
	* Holds the framework's url
	* @type string
	*/
    const APP_URL = 'http://irismvc.net/';


	/**
	* @private
    * @static
	* Holds the reference to the instance of the Configuration classs
	* @type Configuration object
	*/
    private static $_config = null;


    /**
     * @private
     */
    private function __clone(){}
    /**
     * @private
     * Constructor
     */
    private function __construct(){}

	/**
	* @final
	* @public
    * @static
	* Start the application
	*/
	final public static function start()
	{
        global $config;

        /**
        * Load application's settings
        *=================================================================
        */
        require BASE_PATH . 'site.functions.php';
        require BASE_PATH . 'site.settings.php';

        self::$_config = $config;
    }

    /**
     * @final
     * @public
     * @static
     * Retrieve the reference to the instance of the Configuration class
     * @return Configuration object
     */
    final public static function getConfiguration() { return self::$_config; }
    /**
     * @final
     * @public
     * @static
     * Retrieve the reference to the instance of the FrontController class
     * @return FrontController object
     */
    final public static function getFrontController() { return FrontController::getInstance(); }
    /**
     * @final
     * @public
     * @static
     * Retrieve the framework's version
     * @return float
     */
    final public function getVersion() { return self::APP_VERSION; }
    /**
     * @final
     * @public
     * @static
     * Retrieve the framework's status
     * @return string
     */
    final public function getStatus() { return self::APP_STATUS; }
    /**
     * @final
     * @public
     * @static
     * Retrieve the framework's codename
     * @return string
     */
    final public function getCodename() { return self::APP_CODENAME; }
}
/* End of file: Application.php */