<?php if ( ! defined('BASE_PATH')) { return; }
/**
* @package      IrisMVC
* @author       Costin Trifan
* @copyright    2010-2011 Costin Trifan <http://irismvc.net/>
* @license      Microsoft Public License (Ms-PL)  http://irismvc.net/license.txt
* @class View
* The default View class.
*/
class View extends BaseView
{
	/**
	* @public
	* Constructor
	* @param object The reference to the instance of the Configuration class
	* @param object The reference to the instance of the Model class
	*/
	public function __construct( BaseModel $model )
	{
		parent::__construct($model);
	}


	/**
	* @public
	* Retrieve the content of a slot
	* @param string The name of the slot file to load
	* @param string The name of the section directory where to look for the slot file. It can only be
	* one of the following: shared,backend or frontend. Defaults to shared.
	* @return string
	*/
	public function getSlot( $slotFileName, $dir = 'shared' )
	{
        if ( ! Util::endsWith('.php', $slotFileName)) {
            $slotFileName .= '.php';
        }

		$dir = strtolower($dir);
		if ( ! in_array($dir, $this->_availableDirs)) {
			return '';
		}

		switch( $dir )
		{
			case 'backend':
				$filePath = $this->config->backendSlotsDir . $slotFileName;
				break;
			case 'frontend':
				$filePath = $this->config->frontendSlotsDir . $slotFileName;
				break;
			default:
				// 'shared'
				$filePath = SHARED_VIEWS_DIR . $slotFileName;
				break;
		}

		if ( ! is_file($filePath)) {
			return '';
		}

		return $this->getParsed($filePath);
	}

	/**
	* @public
	* Output the content of the view file into the browser window
	* @param string  The name of the view page to load
	* @param string The name of the directory where to search for the view file.
	* @return void
	*/
	public function render( $viewName, $dir )
	{
		$this->pageContent( $this->load($viewName, $dir) );

		if (empty($this->_masterPagePath))
		{
			echo $this->_pageContent;
		}
		else
		{
			echo $this->loadMasterPage();
		}
	}

	/**
	* @public
	* Retrieve the content of the specified view file
	* @param string  the name of the view page to load
	* @param string The name of the directory where to search for the view file.
	* @return string
	*/
	public function get( $viewFile, $dir )
	{
		return $this->load($viewFile, $dir);
	}

	
}