<?php if ( ! defined('BASE_PATH')) { return; }
/**
* Application's core settings
*----------------------------------------
* !! DO NOT EDIT THIS FILE
*/

/**
 * Parse the config ini file and define constants
 */
$_iniData = parse_ini_file(BASE_PATH.'site.config.ini', true);

	define('DEBUG', $_iniData['IrisAppConfig']['debug']);
	define('DEFAULT_CONTROLLER_NAME', $_iniData['IrisAppConfig']['defaultControllerName']);
	define('DEFAULT_THEME_NAME', $_iniData['IrisAppConfig']['defaultThemeName']);
	define('INSTALL_DIR', $_iniData['IrisAppConfig']['installDir']);



/**
* Set the path to your site directory.
* This is where all your website's files should reside.
*/
	define( 'SITE_DIR', BASE_PATH.'site/' );

/**
* Set the path to the 3rd party libraries directory.
*/
	define( 'SITE_LIBS_DIR',  BASE_PATH.'libs/' );

/**
* Set the path to the error log file
*/
	define( 'APP_LOG_FILE_PATH', SITE_DIR.'logs/log.json' );

/**
* Set the path to the code directory.
*/
	define( 'SITE_CODE_DIR',  SITE_DIR.'code/' );

/**
* Set the path to the themes directory.
*/
	define( 'THEMES_DIR', SITE_DIR.'themes/' );

/**
* Set the path to the themes shared directory.
*/
	define( 'THEMES_SHARED_DIR', THEMES_DIR.'_shared/' );

/**
* Set the path to the controllers directory.
* This directory is automatically included in the global include path
*/
	define( 'CONTROLLERS_DIR', SITE_DIR.'controllers/' );

/**
* Set the path to the models directory.
* This directory is automatically included in the global include path
*/
	define( 'MODELS_DIR', SITE_DIR.'models/' );

/**
* Set the path to the views directory.
* This directory will hold all your view files.
*/
	define( 'VIEWS_DIR', SITE_DIR.'views/' );

/**
* Set the path to the shared views directory.
* This directory will hold all the views files shared across the website.
*/
	define( 'SHARED_VIEWS_DIR', VIEWS_DIR.'_shared/' );

/**
* Set the path to the backend views directory.
* This directory will hold all the views files for the website's backend (site administration, user pages, etc.).
*/
	define( 'BACKEND_VIEWS_DIR', VIEWS_DIR.'backend/' );

/**
* Set the path to the frontend views directory.
* This directory will hold all of the public views files of the website.
*/
	define( 'FRONTEND_VIEWS_DIR', VIEWS_DIR.'frontend/' );

/**
* The path to the website's root. Must end with a forward slash!
*/
	$_appUrl = ((!empty($_SERVER['HTTPS']) && (strtoupper($_SERVER['HTTPS']) == 'ON')) ? 'https' : 'http') .'://'. $_SERVER['HTTP_HOST'];
	if (!Util::endsWith('/', $_appUrl)) {
		$_appUrl .= '/';
	}
	if (!Util::endsWith('/', INSTALL_DIR)) {
		$_appUrl .= INSTALL_DIR.'/';
	}
	else { $_appUrl .= INSTALL_DIR; }

	define( 'SITE_PATH', $_appUrl );

/**
* Set the http path to your themes directory
*/
	define( 'THEMES_PATH', SITE_PATH.'site/themes/' );

/**
* Set the http path to your themes shared directory
*/
	define( 'THEMES_SHARED_PATH', THEMES_PATH.'_shared/' );
	

/**
* @ CONFIGURATION
*/
    require_once BASE_PATH . 'sys/base/Configuration.php';
    $config = new Configuration();

    // The path to the application's installation directory
	$config->localDirName = INSTALL_DIR;

	// Default controller name
	$config->defaultControllerName = DEFAULT_CONTROLLER_NAME;


	// sys directories
	$config->sysDir = BASE_PATH . 'sys/';
	$config->sysLibsDir = $config->sysDir . 'libs/';

	// site directories

// VIEWS: SHARED DIRS
	$config->sharedErrorPagesDir = SHARED_VIEWS_DIR.'error-pages/';
// VIEWS: BACKEND DIRS
	$config->backendErrorPagesDir = BACKEND_VIEWS_DIR.'error-pages/';
	$config->backendMasterPagesDir = BACKEND_VIEWS_DIR.'master-pages/';
	$config->backendSlotsDir = BACKEND_VIEWS_DIR.'slots/';
// VIEWS: FRONTEND DIRS
	$config->frontendErrorPagesDir = FRONTEND_VIEWS_DIR.'error-pages/';
	$config->frontendMasterPagesDir = FRONTEND_VIEWS_DIR.'master-pages/';
	$config->frontendSlotsDir = FRONTEND_VIEWS_DIR.'slots/';

	// HTTP paths
	$config->defaultThemePath = THEMES_PATH . DEFAULT_THEME_NAME . '/';


/*
| @@ Add all important dirs into the include path
|-------------------------------------------------
*/
	$a1 = Util::DirToArray($config->sysDir, 1, 0);
	$a2 = Util::DirToArray($config->sysLibsDir, 1, 0);
	$a3 = Util::DirToArray(SITE_LIBS_DIR, 1, 0);
	$__dirs = array_merge($a1, $a2, $a3);
	foreach( $__dirs as $dir )
	{
		Util::addIncludePath($dir . '/');
		$dir = null;
	}
	$__dirs = $a1 = $a2 = null;

	Util::addIncludePath(SITE_CODE_DIR);
	Util::addIncludePath(CONTROLLERS_DIR);
	Util::addIncludePath(MODELS_DIR);
	Util::addIncludePath($config->sysDir.'interfaces/');

/**
| -------------------------------------------------------------------
|  Autoloading classes
| -------------------------------------------------------------------
| This function will make available all classes within this framework
| without the use of the require or include directives.
| The class name must match the class's file name.
*/
function __autoload( $class )
{
    $ext = substr($class, -4);

    if( Util::endsWith('.php', $class) && !class_exists($class) )
    {
        require_once $class;
    }
    else
    {
        if( !class_exists($class . '.php') )
        {
            require_once $class . '.php';
        }
    }
}
/* End of file: core.config.php */