<?php if ( ! defined('BASE_PATH')) { return; }
/*
* @package      IrisMVC
* @author       Costin Trifan
* @copyright    2011 Costin Trifan <http://irismvc.net/>
* @license      Microsoft Public License (Ms-PL)  http://irismvc.net/license.txt
* @class StringBuilder
* This class provides the basic string manipulation functionality.
*/
class StringBuilder
{
	/**
	* @private
	* @ Holds the string
	* @type string
	*/
	private $_str = '';

	/**
	* @public
	* Constructor
	*/
	public function __construct(){}

	/**
	* @public
	* Prepend the $string to the internal string
	* @param string the string to prepend
	* @param string the line break to use. 
	* @return StringBuilder object
	*/
	public function prepend( $string, $lineBreak = '' )
	{
		$string = trim($string);

		if ( !empty($lineBreak) ) { $string .= $lineBreak; }

		$this->_str = $string.$this->_str; 

		return $this;
	}

	/**
	* @public
	* Append the $string to the internal string
	* @param string the string to append
	* @param string the line break to use. 
	* @return StringBuilder object
	*/
	public function append( $string, $lineBreak = '' )
	{
		$this->_str .= rtrim($string);
		if ( !empty($lineBreak) ) { $this->_str .= $lineBreak; }

		return $this;
	}

	/**
	* @public
	* Clear the internal string
	* @return StringBuilder object
	*/
	public function clear()
	{
		$this->_str = '';
		return $this;
	}

	/**
	* @public
	* Retrieve the content of the internal string
	* @return string
	*/
	public function get() { return $this->_str; }

	/**
	* @public
	* Retrieve the content of the internal string
	* @return string
	*/
	public function __toString() { return $this->get(); }
}
/** End StringBuilder.php !*/