<?php
/*
 * @name App.php
 * @desc 系统初始化处理类
 * @author 殇╄→過（418250505@qq.com）
 * @createtime 2011-06-16 12:00
 */

class App{

        static $init;   //类实例化句柄
        public $App_Path;   //项目路径

        /**
         * @name _LoadFile
         * @desc 单例模式实例化
         * @return
         */
        public static function run($App_Path = ''){
                if(is_null(self::$init) && !isset(self::$init)){
                       self::$init = new App($App_Path);
                }
                return self::$init;
        }


        /**
         * @name _LoadFile
         * @desc 构造函数
         * @return
         */
        public function  __construct($App_Path = '') {
                $this->App_Path=$App_Path;
                $this->_Conf();         //系统初始化配置
                $this->_Create();       //创建项目
                $this->_Url();          //Url路由功能
        }


        
        /**
         * @name _LoadFile
         * @desc 加载配置文件与系统初始化设置
         * @return
         */
        public function _Conf(){
                define('WORK_SOURCE',preg_replace("'\\\\'",'/',dirname(__FILE__)).'/');
                define('WORK_ROOT', substr(WORK_SOURCE,0,-6));
                define('YPHP_ROOT',WORK_SOURCE.'source'.DIRECTORY_SEPARATOR);

                $this->_LoadFile('global', 'conf');             //加载全局变量
                $this->_LoadFile('const', 'conf');              //加载系统常量
                WorkCore::registerAutoload();                   //注册自动加载函数
                $this->_LoadFile('setting', 'conf');            //加载系统设置
                $this->_LoadFile('extention', 'function');      //加载系统函数
        }

        

        /**
         * @name _Create
         * @desc 创建项目
         * @return
         */
        public function _Create(){
                global $_G;
                if(!is_dir($this->App_Path)){
                        //创建项目目录结构
                        $objet_dir = array($this->App_Path);
                        mkdirs($objet_dir);
                        $Arr_dir = array($this->App_Path.DIRECTORY_SEPARATOR.'cache', $this->App_Path.DIRECTORY_SEPARATOR.'configs', $this->App_Path.DIRECTORY_SEPARATOR.'model', $this->App_Path.DIRECTORY_SEPARATOR.'template_c', $this->App_Path.DIRECTORY_SEPARATOR.'templates');
                        mkdirs($Arr_dir);

                        //写入项目Smarty配置
                        $Conf_Str = '';
                        $Conf_Str .= '<?php'."\r\n";
                        $Conf_Str .= 'if(!defined(\'WORK\')) exit(\'Cannot access!\');'."\r\n";
                        $Conf_Str .= 'global $_G;'."\r\n";
                        $Conf_Str .= '$_G[\'smarty\'][\'template_dir\'] = WORK_ROOT.\''.$this->App_Path.'/templates/\';   //模板目录'."\r\n";
                        $Conf_Str .= '$_G[\'smarty\'][\'compile_dir\'] = WORK_ROOT.\''.$this->App_Path.'/template_c/\';   //模板编译目录'."\r\n";
                        $Conf_Str .= '$_G[\'smarty\'][\'config_dir\'] = WORK_ROOT.\''.$this->App_Path.'/configs/\';'."\r\n";
                        $Conf_Str .= '$_G[\'smarty\'][\'cache_dir\'] = WORK_ROOT.\''.$this->App_Path.'/cache/\';   //缓存目录'."\r\n";
                        $Conf_Str .= '$_G[\'smarty\'][\'caching\'] = false;              //true开启缓存，false 关闭缓存'."\r\n";
                        $Conf_Str .= '$_G[\'smarty\'][\'cache_lifetime\'] = \'3600\';     //缓存更新时间 秒'."\r\n";
                        $Conf_Str .= '$_G[\'smarty\'][\'left_delimiter\'] = \'<{\';'."\r\n";
                        $Conf_Str .= '$_G[\'smarty\'][\'right_delimiter\'] = \'}>\';'."\r\n\r\n\r\n";
                        $Conf_Str .= '/****************_YPHP默认参数配置****************/'."\r\n";
                        $Conf_Str .= '$_G[\'_YPHP\'][\'model\'] = \'Index\';     //功能模块默认执行的类名称（注意首字母必须大写）'."\r\n";
                        $Conf_Str .= '$_G[\'_YPHP\'][\'option\'] = \'Demo\';     //功能模块默认执行的类里面的默认执行方法 （注意首字母必须大写）'."\r\n";
                        
                        $Conf_Str .= 'return $_G;'."\r\n";
                        $Conf_Str .= '?>';
                        file_put_contents($this->App_Path.DIRECTORY_SEPARATOR.'configs'.DIRECTORY_SEPARATOR.'config.php', $Conf_Str);

                        //建立测试项目
                        $objet_Str = '';
                        $objet_Str .= '<?php'."\r\n";
                        $objet_Str .= 'class Index extends Action{'."\r\n\r\n";
                        $objet_Str .= '       public function Demo(){'."\r\n";
                        $objet_Str .= '               $string = \'恭喜，您现在可以使用本框架来创建项目啦！\';'."\r\n";
                        $objet_Str .= '                $Assign[\'string\'] = $string;'."\r\n";
                        $objet_Str .= '                ShowHtml(\'demo.html\', $Assign);'."\r\n";
                        $objet_Str .= '        }'."\r\n";
                        $objet_Str .= '}';
                        $objet_Str .= '?>';
                        file_put_contents($this->App_Path.DIRECTORY_SEPARATOR.'model'.DIRECTORY_SEPARATOR.'Index.class.php', $objet_Str);

                        //建立测试模版
                        $Html_Str = '';
                        $Html_Str .= '<{$string}>';
                        file_put_contents($this->App_Path.DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'demo.html', $Html_Str);
                }
        }

        
        /**
         * @name _LoadFile
         * @desc 加载文件函数
         * @return 
         */
        public function _LoadFile($FileName, $Path=''){
                $Path = YPHP_ROOT.($Path?$Path.DIRECTORY_SEPARATOR : '').$FileName.($Path ? '.'.$Path : '').'.php';
                if(file_exists($Path)){
                        include $Path;
                }else{
                        echo 'File does not exist! Path :  '.$Path.'<br />';
                        exit(0);
                }
        }


        /**
         * @name _Url
         * @desc URL路由功能
         * @return
         */
        public function _Url(){
                global $_G;
                //重新加载Smarty配置文件
                $this->App_Path = $this->App_Path ? $this->App_Path.DIRECTORY_SEPARATOR : '';
                $SmartyConf = WORK_ROOT.$this->App_Path.'configs/config.php';
                if(file_exists($SmartyConf)){
                        include $SmartyConf;
                        $http = $_REQUEST;
                        $m = isset($http['m']) ? ucfirst($http['m']) : ($_G['_YPHP']['model'] ? $_G['_YPHP']['model'] : 'Index');
                        $op = isset($http['op']) ? ucfirst($http['op']) : ($_G['_YPHP']['option'] ? $_G['_YPHP']['option'] : 'Demo');

                        //加载功能类文件
                        $Path = WORK_ROOT.$this->App_Path.'model'.DIRECTORY_SEPARATOR.$m.'.class.php';
                        if(file_exists($Path)){
                                include $Path;
                                if(class_exists($m) && method_exists($m, $op)){
                                        $class = new $m;
                                        $class -> $op();
                                }else{
                                        echo '类或类的方法不存在! Path :  '.$Path.'<br />';
                                        exit(0);
                                }

                        }else{
                                echo 'File does not exist! Path :  '.$Path.'<br />';
                                exit(0);
                        }
                        
                }else{
                        echo 'File does not exist! Path :  '.$SmartyConf.'<br />';
                        exit(0);
                }
        }

        

}




/**
 * 创建自动加载类
 */
class WorkCore {
        public static function registerAutoload($class = 'WorkCore') {
                spl_autoload_register(array($class, 'autoload'));
        }

        public static function unregisterAutoload($class) {
                spl_autoload_unregister(array($class, 'autoload'));
        }

        public static function autoload($class_name) {
                //YEPF系统类数组
                $classarray = array('App', 'Action', 'Bug', 'MySQL');
                if(in_array($class_name, $classarray)){
                        return include YPHP_ROOT.'class'.DIRECTORY_SEPARATOR.$class_name.'.class.php';
                }
                return false;
        }
}
?>
