<?php
/**
 * @name App.class.php
 * @desc url 路由规则定义
 * @author 殇╄→過（418250505@qq.com）
 * @createtime 2011-06-16 12:00
 */

$urlRule = array(

    'user' => array(            // control

        'lists' => array(       // action

            //'名称'    => '默认值,值模式匹配'

            'filter'    => 'all,^(all|normal|admin)$',

            'order'     => ',^-?[a-zA-Z_]+$',

            'curPage'   => '1,^[0-9]+$',

          ),

    ),

);

function parseUrl(){

        $queryString = array();

        $GLOBALS['control'] = 'index';

        $GLOBALS['action'] = 'index';

        if (isset($_SERVER['PATH_INFO'])){

                //获取  pathinfo

                $aPathInfo = explode('/', substr($_SERVER['PATH_INFO'], 1, strrpos($_SERVER['PATH_INFO'], '.')-1));

                // 获取 control

                $GLOBALS['control'] = $aPathInfo[0];

                array_shift($aPathInfo);

                // 获取 action

                $GLOBALS['action'] = (isset($aPathInfo[0]) ? $aPathInfo[0] : 'index');

                array_shift($aPathInfo);

                // 获取 入口文件名

                $GLOBALS['PHP_SELF'] = str_replace($_SERVER['PATH_INFO'], '', $_SERVER['PHP_SELF']);

                $queryString = $aPathInfo;

        }

        parseQueryString($queryString);

}

function parseQueryString(array$aQueryString){

        $queryString = array();

        // control 与 action 为默认值时

        if ($GLOBALS['control'] == 'index' && $GLOBALS['action'] == 'index'){

                $GLOBALS['queryString'] = $queryString;

                return true;

        }

        global $urlRule;

        if (isset($urlRule[$GLOBALS['control']][$GLOBALS['action']])){

                $aActionRule = &$urlRule[$GLOBALS['control']][$GLOBALS['action']];

                foreach ($aActionRule as $key=>$val){

                        // 规则值为 '' 时

                        if ($val == '') {

                                $queryString[$key] = '';

                                continue;

                        }

                        if (isset($aQueryString[0])){

                                // 取得正则表达式

                                $pattern = '/'.substr($val, strpos($val, ',')+1).'/';

                                // 模式匹配

                                if (preg_match($pattern, $aQueryString[0])){

                                        // 取值

                                        $queryString[$key] = $aQueryString[0];

                                        // 弹出值

                                        array_shift($aQueryString);

                                }else {

                                        // 取默认值

                                        $queryString[$key] = substr($val, 0, strpos($val, ','));

                                }

                        }else {

                                // 取默认值

                                $queryString[$key] = substr($val, 0, strpos($val, ','));

                        }

                }

                $GLOBALS['queryString'] = $queryString;

        }else {

                throw new Exception('试图访问不存在的页面');

        }

}

parseUrl();

var_dump($GLOBALS['control']);

var_dump($GLOBALS['action']);

var_dump($GLOBALS['queryString']);



/**
         * Pathinfo函数
         * 功能:将URL中的Pathinfo解析为$_GET全局变量
         * 返回值:解析成功返回true否则为fasle
         * 例如:http://hostname/page.php/argv/argc/a/1/b/2.html
         * 将会解析为$_GET['argv']='argc';$_GET['a']=1;$_GET['b']=3;
         */
        function pathinfo(){
                $pathinfo=explode('/',$_SERVER['PATH_INFO']);
                $count=count($pathinfo);
                for($foo=1;$foo<$count;$foo+=2){
                        $_GET[$pathinfo[$foo]]=($foo+2)==$count?array_shift(explode('.',$pathinfo[$foo+1])):$pathinfo[$foo+1];
                }
        }
        /**
         * rewrite函数
         * 功能:
         */
        Function rewrite($url=null){
                return REWRITE?$url.'.html':$_SERVER['PHP_SELF'].$url.'.html';
        }
?>
