<?php
/*
 * @name Buy.class.php
 * @desc 错误调试处理类
 * @author 殇╄→過（418250505@qq.com）
 * @createtime 2011-06-16 12:00
 */
if(!defined('WORK')) exit('Can\'t access!');

class Bug{

        /**
         * @name Start
         * @desc 注册错误函数
         * @return 无返回值
         */
        public static function Start(){
                ini_set('display_errors', true);
                set_error_handler(array('Bug', 'ErrorShow'), ERROR_LEVEL);      //自定义php错误函数
        }

        /**
         * @name ErrorShow
         * @desc 错误处理函数
         * @param string $msg 附加信息
         * @return string
         */
        public static function ErrorShow($error_level, $error_message, $error_file, $error_line){
                //输出错误信息
                if(DEBUY == true){
                        $EHtml = '';
                        $EHtml .= "<div style='border:#FF9900 1px dashed; background:#FFF5E6; padding:5px; line-height:25px; font-size:14px; color:#454545;width:99%; margin:0 auto;'>";
                        $EHtml .= "<h5 style='margin:0; padding:0; line-height:28px; color:#FF0000;'>PHP Error :</h5>";
                        $EHtml .= "错误级别：".$error_level.'<br />';
                        $EHtml .= "错误信息：".$error_message.'<br />';
                        $EHtml .= "错误文件：".$error_file.'<br />';
                        $EHtml .= "错误行号：".$error_line.'<br />';
                        $EHtml .= "</div><br />";
                        echo $EHtml;
                }

                //记录错误信息
                if(RECORDLOG == true){
                        $EStr = '';
                        $EStr .= "【".date('Y-m-d H:i:s')."】"."\r\n";
                        $EStr .= "	错误级别：".$error_level."\r\n";
                        $EStr .= "	错误信息：".$error_message."\r\n";
                        $EStr .= "	错误文件：".$error_file."\r\n";
                        $EStr .= "	错误行号：".$error_line."\r\n\r\n\r\n";
                        Error_log($EStr,3,ERR_LOG.'WLog'.date('Ymd').'.txt');
                }
        }


        /**
         * 调试信息显示
         */
        public static function Show(){
                $SHtml = '';
                $SHtml .= "<div style='border:#CCCCCC 1px dashed; padding:5px; line-height:22px; font-size:12px; color:#666666;width:99%; margin:0 auto;'>";
                $SHtml .= GetEndTime('执行时间：').' S';
                $SHtml .= "</div>";
                echo $SHtml;
        }
}
?>
