<?php
/*
 * @name MySQL.class.php
 * @desc MySQL数据库操作类
 * @author 殇╄→過（418250505@qq.com）
 * @createtime 2011-06-16 12:00
 */
if(!defined('WORK')) exit('Can\'t access!');

class MySQL {
        //数据库配置信息
	private $config = array();
        //连接默认值
        static $instance = null;
        //数据库连接资源句柄
	public $link;
        //最近一次查询资源句柄
	public $queryid = null;
        //统计数据库查询次数
	public $querycount = 0;

        /**
         * 构造函数
         */
        private function __construct() {
                global $_G;
                $this->config=$_G['db'];
                $func = $this->config['pconnect'] == 1 ? 'mysql_pconnect' : 'mysql_connect';
		if(!$this->link = @$func($this->config['host'], $this->config['root'], $this->config['pass'], 1)) {
			$this->Tip('Can not connect to MySQL server');
			return false;
		}
		if($this->config['dbname'] && !@mysql_select_db($this->config['dbname'], $this->link)) {
			$this->Tip('Cannot use database '.$this->config['dbname']);
			return false;
		}
                mysql_query("SET NAMES ".$this->config['charset'], $this->link);
		return $this->link;
	}



        /**
         * @name init
         * @desc 单例模式初始化数据库
         * @return 返回实例化对象
         */
	public static function init(){
                if(is_null(self::$instance) || !isset(self::$instance)){
                        self::$instance = new MySQL();
                }
                return self::$instance;
	}


        
        /**
         * @name GetList
         * @desc 获取一条或多条记录
         * @return 返回数组
         */
        public function GetList($sql){
                $this->queryid = $this->Query($sql);
                if($this->queryid){
                        while($row = $this->fetch_array($this->queryid)){
                                $result[] = $row;
                        }
                }
                $this->free_result($this->queryid);
                return $result;
        }


        /**
         * @name GetNum
         * @desc 通过SQL获取记录集总数
         * @return 返回数字
         */
        public function GetNum($sql){
                return $this->num_rows($this->Query($sql));
        }


        
        /**
         * @name Query
         * @desc 执行SQL语句
         * @return 返回资源标识符
         */
        public function Query($sql){
                $this->queryid = mysql_query($sql, $this->link) or $this->Tip(mysql_error(), $sql);
		$this->querycount++;
		return $this->queryid;
        }



        /**
         * @name insert_id
         * @desc 获取添加的ID
         * @return 返回获取最后一次添加记录的主键号
         */
	public function insert_id() {
		return mysql_insert_id($this->link);
	}



        /**
         * @name fetch_array
         * @desc 执行query返回的数据标识
         * @return 返回结果集
         */
	public function fetch_array($query, $method = MYSQL_ASSOC) {
		return mysql_fetch_array($query, $method);
	}



	/**
	 * @name freeResult
	 * @desc 释放结果内存
	 * @return bool
	 */
	public function free_result($query){
		return mysql_free_result($query);
	}
        


	/**
	 * @name query
	 * @desc 执行SQL操作
	 */
	public function num_rows($query) {
		return mysql_num_rows($query);
	}



        /**
         * @name Version
         * @desc 返回MySQL服务器版本信息
         * @return 无返回值
         */
	public function Tip($Str, $sql='') {
                $sql = $sql ? "错误语句：".$sql."<br />" : '';
                $SHtml = '';
                $SHtml .= "<div style='border:#FF9900 1px dashed; background:#FFF5E6; padding:5px; line-height:25px; font-size:14px; color:#454545;width:99%; margin:0 auto;'>";
                $SHtml .= "<h5 style='margin:0; padding:0; line-height:28px; color:#FF0000;'>MySQL Error :</h5>";
                $SHtml .= "错误说明：".$Str."<br />".$sql;
                $SHtml .= "</div><br />";
                echo $SHtml;
                exit;
	}

}

?>
