<?php
/**
 * @name extention.function.php
 * @desc 系统函数
 * @author 殇╄→過（418250505@qq.com）
 * @createtime 2011-06-16 12:00
 */


/**
 * @name getEndTime
 * @desc 计算执行页面所需时间函数
 * @param string $msg 附加信息
 * @return string
 */
function GetEndTime($msg = '')
{
	return $msg . round((microtime(true) - START_TIME),5);
}



/**
 * @name getEndTime
 * @desc 批量创建目录
 * @param $dirs 目录数组
 * @return 
 */
function mkdirs($dirs,$mode=0777) {
    foreach ($dirs as $dir){
        if(!is_dir($dir))  mkdir($dir,$mode);
    }
}


/**
 * @name db
 * @desc 数据库实例化
 * @return  返回对象
 */
function db(){
        return MySQL::init();
}

/**
 * @name getClientIp
 * @desc 获得客户端ip
 * @return  string client ip
 */
function GetIP(){
	if(getenv('HTTP_CLIENT_IP') && strcasecmp(getenv('HTTP_CLIENT_IP'), 'unknown')) {
		$onlineip = getenv('HTTP_CLIENT_IP');
	} elseif(getenv('HTTP_X_FORWARDED_FOR') && strcasecmp(getenv('HTTP_X_FORWARDED_FOR'), 'unknown')) {
		$onlineip = getenv('HTTP_X_FORWARDED_FOR');
	} elseif(getenv('REMOTE_ADDR') && strcasecmp(getenv('REMOTE_ADDR'), 'unknown')) {
		$onlineip = getenv('REMOTE_ADDR');
	} elseif(isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], 'unknown')) {
		$onlineip = $_SERVER['REMOTE_ADDR'];
	}
	return $onlineip;
}
/**
 * @name redirect
 * @desc 跳转函数
 * @param string $url 跳转的url
 **/
function Head($url){
	if(!empty($url))	{
		header("Location: ".$url."");
	}
	exit;
}



//获取Smarty
function GetSmarty($Smarty){
        if(!is_array($Smarty)){
                echo 'Smarty 实例化必要参数获取失败！';
                exit(0);
        }

        if(!(is_dir($Smarty['template_dir']) || is_dir($Smarty['template_dir']) || is_dir($Smarty['template_dir']))){
                echo '缓存目录不存在';
                exit(0);
        }
        if(file_exists($Smarty['classfile'])){
                include_once($Smarty['classfile']);
                $SmartyClass = new Smarty();
                $SmartyClass -> template_dir = $Smarty['template_dir'];
                $SmartyClass -> compile_dir = $Smarty['compile_dir'];
                $SmartyClass -> config_dir = $Smarty['config_dir'];
                $SmartyClass -> cache_dir = $Smarty['cache_dir'];
                $SmartyClass -> caching = $Smarty['caching'];
                //$SmartyClass -> cache = $Smarty['cache'];
                //$SmartyClass -> compile_check = $Smarty['compile_check'];
                $SmartyClass -> cache_lifetime = $Smarty['cache_lifetime'];  //缓存时间
                $SmartyClass -> left_delimiter = $Smarty['left_delimiter'];
                $SmartyClass -> right_delimiter = $Smarty['right_delimiter'];
                return $SmartyClass;
        }else{
                echo 'Smarty 实例化失败';
        }
}

//显示html结束成功
function ShowHtml($TempHtml, $Data=NULL, $Smarty=NULL, $SmartyToo=NULL){
        global $_G;
        $SmartyArr = $_G['smarty'];
        $TempPath = $SmartyArr['template_dir'].$TempHtml;
        if(file_exists($TempPath)){
                $Smarty = GetSmarty($SmartyArr);
                if(is_object($Smarty)){
                        if(is_array($Data) && count($Data) > 0){
                                foreach($Data as $Key => $Val){
                                        $Smarty -> assign(is_numeric($Key{0})?'A'.$Key:$Key, $Val);
                                }
                        }
                        $Smarty->display($TempHtml);
                        exit(0);
                }
        }else{
                echo '模版文件['.$TempHtml.']未找到!';
        }




/**
         * Pathinfo函数
         * 功能:将URL中的Pathinfo解析为$_GET全局变量
         * 返回值:解析成功返回true否则为fasle
         * 例如:http://hostname/page.php/argv/argc/a/1/b/2.html
         * 将会解析为$_GET['argv']='argc';$_GET['a']=1;$_GET['b']=3;
         */
//        function pathinfo(){
//                $pathinfo=explode('/',$_SERVER['PATH_INFO']);
//                $count=count($pathinfo);
//                for($foo=1;$foo<$count;$foo+=2){
//                        $_GET[$pathinfo[$foo]]=($foo+2)==$count?array_shift(explode('.',$pathinfo[$foo+1])):$pathinfo[$foo+1];
//                }
//        }


}

?>
