<?php
 /**
 +------------------------------------------------------------------------------
 * Framk PHP框架
 +------------------------------------------------------------------------------
 * @package  Framk
 * @author   shawn fon <shawn.fon@gmail.com>
 +------------------------------------------------------------------------------
 */
 
class Database {

private $db;

 /* 
 +------------------------------------------------------------------------------
 * 初始化数据库
 +------------------------------------------------------------------------------
 */	 
	public function __construct(){		 
		$this->db = _instance(FRAMK.$GLOBALS['DB']['DBtype']);				 
	} 
 /* 
 +------------------------------------------------------------------------------
 * 查询结果集并转换为二维数组
 +------------------------------------------------------------------------------
 */	 
	public	function findAll($sql){ 
	
		$data= array(); $row= array ();	$i=0;
		$result = $this->db->query($sql);	
		if(!$result)return false;
		while ( ($row  = $this->db->fetch_array($result)) ) {	
		$data[$i++]=$row;				
		} 
		$this->db->free_result($result);	 
		return $data; 	 
	}	

 /* 
 +------------------------------------------------------------------------------
 * 查询结果集数组（一维数组）
 +------------------------------------------------------------------------------
 */	 
	public	function findOne($sql){
	
		$result = $this->db->query($sql);						 
		$data=$this->db->fetch_array($result);	
		$this->db->free_result($result);	 
		return $data;
	}

 /* 
 +------------------------------------------------------------------------------
 * 数据记录条数
 +------------------------------------------------------------------------------
 */	 
	public function countRecords($sql){	
	
		$result = $this->db->query($sql);	 		
		return $this->db->num_rows($result);		
	}

 /* 
 +------------------------------------------------------------------------------
 * 更新数据，返回值：新增数据ID、影响的记录条数
 +------------------------------------------------------------------------------
 * 如果数据操作返回为真
 * 根据不同方法返回值
 +------------------------------------------------------------------------------
 */	 	
	public function updt($sql){

		$result=$this->db->query($sql);
		if($result){
			$sql=trim($sql);
			$method=strtolower (substr($sql,0,6));
			if($method=='insert'||$method=='replace'){
			return  $this->db->insert_id();	
			}else{
			return $this->db->affected_rows();
			}		
		}else{
		return false;
		}	
	}

 /*  +------------------------------------------------------------------------------ */		

} //
?>