<?php
 /**
 +------------------------------------------------------------------------------
 * Framk PHP框架
 +------------------------------------------------------------------------------
 * @package  Framk
 * @author   shawn fon <shawn.fon@gmail.com>
 +------------------------------------------------------------------------------
 */
 
class Dispatcher {
		
	private $actionDir='';

 /* 
 +------------------------------------------------------------------------------
 * 构造函数：访问路径分析
 +------------------------------------------------------------------------------
 * 定义项目路径 APP
 * 定义访问路径前缀 ACT
 * 取得当前index.php之后的字符串
 +------------------------------------------------------------------------------
 */	 
	public function __construct() {
		 		 
		$scriptName= $_SERVER ['SCRIPT_NAME'];
		$requestURI= $_SERVER ['REQUEST_URI'];		
		$appName = str_replace ( '/index.php', '', $scriptName );

		define ( 'APP',   ( strlen(APP_NAME)===0 ? $appName : $appName.'/'.APP_NAME) );		
		define ( 'ACT',   ( $GLOBALS['ReWrite'] ? $appName : $scriptName) );		
		($requestURI ==$appName.'/')? $urlStr='': $urlStr=str_replace (ACT, '', $requestURI );					 
		$this->getAction ( $this->filterParams($urlStr) );//
	}
 /* 
 +------------------------------------------------------------------------------
 * 过滤访问地址：返回值：访问参数数组
 +------------------------------------------------------------------------------
 * 过滤'?\&\=\.html'
 * 确定Action是否有子级目录
 +------------------------------------------------------------------------------
 */	 		
	private function filterParams($urlStr) {
	
		$urlStr=substr($urlStr,1);
		if(!empty($_SERVER['QUERY_STRING']))$urlStr =str_replace(array('&','='),'/',$urlStr);
		$urlArr=explode ( '/', $urlStr );
		if($GLOBALS['ReWrite']&&!empty($GLOBALS['htmlExt']))
		array_splice($urlArr,-1,1,array(str_replace($GLOBALS['htmlExt'],'',$urlArr[count($urlArr)-1]) ));
		
		foreach($urlArr as $key=>$value){					
			$firstLetter = substr($value,0,1);			
			if($firstLetter== strtolower ($firstLetter)){
				$this->actionDir .=$value.'/' ;			
				unset($urlArr[$key]);
			}else{
				break;
			}			
		}		 
		  return array_merge($urlArr,array());
	}	
 /* 
 +------------------------------------------------------------------------------
 * 取得Ation类与方法，传递参数
 +------------------------------------------------------------------------------
 * 确定Action类与方法
 * 传递参数
 * 调用doAction方法
 +------------------------------------------------------------------------------
 */	 	
	private function getAction($urlArray) {			 		 

		empty ( $urlArray[0]) ? $action = 'Index' : $action = $urlArray[0];
		empty ( $urlArray[1] ) ? $method = 'execute' : $method = $urlArray[1];
		$paramsNum = count ( $urlArray );		
		if ($paramsNum > 2){
			for ($i=2;$i<$paramsNum;$i++) {
				if($GLOBALS['URLMode']==0){	
					$_GET[ $urlArray[$i] ] = $urlArray[++$i];
				}else{					
					$_GET[$i-2]= $urlArray [$i];
				}
			}			 							
		}
		
		$actionFile =  ACTION.$this->actionDir.$action;
		$actionFile_default =  ACTION.$GLOBALS['ActionDir'].$action;
		if (file_exists($actionFile.'.class.php')) {			
			$this->doAction($actionFile ,$action,$method);		
		} else if (file_exists($actionFile_default.'.class.php')) {			
			$this->doAction($actionFile_default ,$action,$method);						
		} else {
			_error('Error',' 请检查此文件是否存在:'.$this->actionDir.$action.'.class.php');	 		
		}				
	
	}
 /* 
 +------------------------------------------------------------------------------
 * 实例化Action类并调用方法
 +------------------------------------------------------------------------------
 */	 	
	private function doAction($actionFile ,$Action,$method){

			$action = _instance($actionFile);	
			if (method_exists ( $action, $method )) {	
			$action->$method ();					 		
			} else {
			_error('methodNotExist', $Action.'类不存在该方法:'.$method);
			}					
	}
	
 /*  +------------------------------------------------------------------------------ */
}//
?>