<?php
 /**
 +------------------------------------------------------------------------------
 * Framk PHP框架
 +------------------------------------------------------------------------------
 * @package  Framk
 * @author   shawn fon <shawn.fon@gmail.com>
 +------------------------------------------------------------------------------
 */
	@header("content-Type: text/html; charset=utf-8 ");
	if (substr(PHP_VERSION, 0, 1) != '5')_error('error','Framk框架运行环境要求PHP5以上,当前版本为：'.PHP_VERSION);
	$GLOBALS= _config(require(FRAMK . '_Config.php'),require(EXTEND . 'Config.php'));//获取配置
	$mtime = explode(' ',microtime()); $GLOBALS['StartRunTime']= $mtime[1] + $mtime[0];
	
	$GLOBALS['Debug'] ? error_reporting ( E_ALL ) : error_reporting ( 0 );	
	if ($GLOBALS['Session'])@session_start();
	if (version_compare ( PHP_VERSION, '5.0.0', '>' ))  @date_default_timezone_set ('Asia/Shanghai');	
	//@set_magic_quotes_runtime(0);

 /* 
 +------------------------------------------------------------------------------
 * 获取配置参数; 返回值：配置数组
 +------------------------------------------------------------------------------
 * 合并系统配置与用户配置，将用户配置覆盖系统配置
 +------------------------------------------------------------------------------
 */	 
	function _config($_Config,$userConfig) {
	
		$config=array();	
		$configArray = array_merge ($_Config ,$userConfig);
		foreach ( $configArray as $key => $value ) {			
		$config[$key] = $value;
		}	
		return $config;
	}

 /* 
 +------------------------------------------------------------------------------
 * 建立多级目录; 返回值：目录
 +------------------------------------------------------------------------------
 * 如果存在则返回目录，否则循环建立多级目录再返回目录
 +------------------------------------------------------------------------------
 */		
	function _mkdir($dir, $mode = 0777) {
		
		if (is_dir ( $dir )) {
			return  $dir;
		} else {
			_mkdir(dirname($dir), $mode);
			@mkdir($dir, $mode);
			return  $dir;
		}	
	}	
 /* 
 +------------------------------------------------------------------------------
 * 加载并实例化类; 返回值：类对象 
 +------------------------------------------------------------------------------
 * 取得类名
 * 加载类文件
 * 判断是否已存在该实例，避免重复实例化同一个类
 +------------------------------------------------------------------------------
 */	 
	function _instance($classFile, $args =array()) {
		
		static $isNew=array();
		$arr = explode ( '/',$classFile);
		$className = $arr [count ( $arr ) - 1] ;
		_import($classFile.'.class.php');
		if(isset($isNew[$className])){
			return $isNew[$className];
		}else{
			if(class_exists($className)){
			$isNew[$className] = new $className($args);
			return $isNew[$className];		
			}else{
			_error ( 'classError', '文件名应与类名一致并且文件后缀应以.class.php结尾：'.$className.' 类不存在', true);
			}

		}	

	}

 /* 
 +------------------------------------------------------------------------------
 * 加载文件; 返回值：true
 +------------------------------------------------------------------------------
 * 判断文件是否存在 可读
 * 避免重复加载
 +------------------------------------------------------------------------------
 */	 	
	function _import($file) {
	
		static $isLoad=array();	
		$importFile =str_replace ( '/', S, $file );	
		if (file_exists($importFile) && is_readable($importFile)){
			if(isset($isLoad[$importFile])){
			return true;
			}else{
			require($importFile);
			$isLoad[$importFile]=true;
			return true;
			}
		}else{
		_error ( 'fileNotExist', '请检查文件是否存在:'.$importFile,true);	
		}				

	}

 /* 
 +------------------------------------------------------------------------------
 * 错误提示; 输出错误信息
 +------------------------------------------------------------------------------
 * 如果Debu为真则显示详细，否则直接显示“访问出错”跳回或到主页
 +------------------------------------------------------------------------------
 */	 
	function _error($errorKey, $detail = '',$exit=false) {
		
		if ($GLOBALS['Debug']==true) {	
		
			$errorArray = require (FRAMK . '_Error.php');		 
			foreach ( $errorArray  as $key => $value ) {
				if (trim($key) == trim($errorKey)) {													
				echo  
				'<div style="border:solid 1px #ccc;padding:5px;background-color:#eee;color:brown;font-size:12px;">!'.$value .' : ' . $detail.'</div>';
				if($exit)exit();												
				}
			}
			
		}else{
			echo 
			'<div style="border:solid 1px #ccc;padding:5px;background-color:#eee;color:brown;font-size:12px;">
			<meta http-equiv="Refresh" content=3;URL='.ACT.'>
			!访问出错
			</div>';//可以自己设定
			exit();	
		}			
	}
	
	function _substr($str,$len){
		for($i=0;$i<$len;$i++){
			$temp_str=substr($str,0,1);
			if(ord($temp_str) > 127){
				$i++;
				if($i<$len){
					$new_str[]=substr($str,0,3);
					$str=substr($str,3);
				}
			}else{
				$new_str[]=substr($str,0,1);
				$str=substr($str,1);
			}
		}
		return join($new_str);
	}
 /*  +------------------------------------------------------------------------------ */
?>