<?php 
// +---------------------------------------------------------------
// | Package: Tommy Framework
// +---------------------------------------------------------------
// | Version $Id: Application.class.php 2010-3-30 12:30:30 $
// +---------------------------------------------------------------
// | Copyright (c) 2009 http://www.tommyframework.com All rights reserved.
// +---------------------------------------------------------------
// | Author: tommy <service@tommyframework.com>
// +---------------------------------------------------------------

if(!defined('IN_TOMMY')){
	exit;
}
abstract class Application {
	
	//定义变量
	public static $controller;  //constroller.
	public static $action;		//action
	
	/**
     +----------------------------------------------------------
     * 分析URL信息,获取controller及action.
     +----------------------------------------------------------
     * @access private
     +----------------------------------------------------------
     */
	private static function parsePath(){
		if(TOMMY_REWRITE==true){
			$path_url = str_replace(str_replace('/index.php', '', $_SERVER['SCRIPT_NAME']), '', $_SERVER['REQUEST_URI']);
		}
		else{
			$page_url = strlen($_SERVER['SCRIPT_NAME'])>strlen($_SERVER['REQUEST_URI']) ? $_SERVER['SCRIPT_NAME'] : $_SERVER['REQUEST_URI'];

			$path_url = str_replace($_SERVER['SCRIPT_NAME'], '', $page_url);
		}		
		$path_info = explode('/', $path_url);		
		//确定Controller,Action.
		self::$controller = ($path_info[1]==true) ? ucfirst(strtolower($path_info[1])).'Controller' : 'IndexController';
		self::$action = ($path_info[2]==true)? strtolower($path_info[2]).'Action' : 'indexAction';		
		//重组参数
		$num = sizeof($path_info);		
		if($num>4){	
			for($i=3; $i<$num; $i+=2){
				$key = $path_info[$i];
				if($key ==''){
					continue;
				}
				$value = $path_info[$i+1];
				$_GET[$key]=$value;
			}
		}		
		return true;
	}
	
	/**
     +----------------------------------------------------------
     * 项目运行函数
     +----------------------------------------------------------
     * @access public
     +----------------------------------------------------------
     * @return obj
     +----------------------------------------------------------
     */
	public static function Run(){		
		static $app = array(); //静态变量，用于存贮CONTROLLER,ACTION的ID
		self::parsePath();
		$id = self::$controller.self::$action;	
		if($app[$id] == null){
			$app_obj = new self::$controller;			
			if(method_exists(self::$controller, self::$action)){
				$action = self::$action;
				$app[$id] = $app_obj->$action();
			}
			else{
				if(TOMMY_DEBUG == true){
					trigger_error('Class:'.self::$controller.' has not Method:'.self::$action, E_USER_ERROR);
				}
				else {
					self::display_404_error();
				}
			}
		}
		return $app[$id];
	}

	/**
     +----------------------------------------------------------
     * 显示404错误信息
     +----------------------------------------------------------
     * @access public
     +----------------------------------------------------------
     * @return string
     +----------------------------------------------------------
     */
	public function display_404_error(){
		if(file_exists(APP_ROOT.'/themes/error/error404.html')){
			include APP_ROOT.'/themes/error/error404.html';
		}
		else{
			include TOMMY_ROOT.'/views/html/tommy_404_Error.html';
		}
		exit;
	}

	//核心类引导数组. example:''=>'/lib/',
	public static $core_classes = array(
	'Base'=>'/core/Base.class.php',
	'Model'=>'/core/Model.class.php',
	'Db'=>'/core/Db.class.php',
	'View'=>'/core/View.class.php',
	'Controller'=>'/core/Controller.class.php',
	'Widget'=>'/core/Widget.class.php',
	'Log'=>'/core/Log.class.php',
	'Cache'=>'/core/Cache.class.php',
	'Db_Mysqli'=>'/core/db_driver/Db_Mysqli.class.php',
	'Db_Pdo'=>'/core/db_driver/Db_Pdo.class.php',
	'pagelist'=>'/lib/pagelist.class.php',	
	'dbcache'=>'/lib/dbcache.class.php',
	'imagelib'=>'/lib/imagelib.class.php',
	'filelist'=>'/lib/filelist.class.php',
	'fileupload'=>'/lib/fileupload.class.php',	
	'script'=>'/lib/script.class.php',	
	'html'=>'/lib/html.class.php',
	'cookie'=>'/lib/cookie.class.php',
	'session'=>'/lib/session.class.php',
	'zip'=>'/lib/zip.class.php',
	'excel'=>'/lib/excel.class.php',	
	'xml'=>'/lib/xml.class.php',
	'calendar'=>'/lib/calendar.class.php',		
	'pinyin'=>'/lib/pinyin.class.php',
	'regexp'=>'/lib/regexp.class.php',
	'client'=>'/lib/client.class.php',
	);
	
	/**
	+----------------------------------------------------------
	* 系统自动加载TommyFramework基类库和当前项目的model和Action对象
	* 并且支持配置自动加载路径
	+----------------------------------------------------------
	* @param string $class_name 对象类名
	+----------------------------------------------------------
	* @return void
	+----------------------------------------------------------
	*/
	public static function autoload($class_name){		
		if(isset(self::$core_classes[$class_name])){
			include TOMMY_ROOT.self::$core_classes[$class_name];
		}
		else if(substr($class_name, -10) == 'Controller'){
			if(file_exists(APP_ROOT.'/controllers/'.$class_name.'.class.php')){
				include APP_ROOT.'/controllers/'.$class_name.'.class.php';
			}
			else{
				if(TOMMY_DEBUG == true){
					trigger_error('Class:'.$class_name.' is not exists!', E_USER_ERROR);
				}
				else {
					self::display_404_error();
				}
			}
		}
		else if(substr($class_name, -5) == 'Model'){
			if(file_exists(APP_ROOT.'/models/'.$class_name.'.class.php')){
				include APP_ROOT.'/models/'.$class_name.'.class.php';
			}
			else {
				trigger_error('Class:'.$class_name.' is not exists!', E_USER_ERROR);
			}
		}
		else {
			if(file_exists(APP_ROOT.'/widgets/'.$class_name.'.class.php')){
				include APP_ROOT.'/widgets/'.$class_name.'.class.php';
			}
			else{
				trigger_error('Class:'.$class_name.' is not exists!', E_USER_ERROR);
			}
		}
	}
}
//注册__autoload()函数.
spl_autoload_register(array('Application','autoload'));
?>