<?php
// +---------------------------------------------------------------
// | Package: Tommy Framework
// +---------------------------------------------------------------
// | Version $Id:Cache.class.php 2010-3-30 12:30:30 $
// +---------------------------------------------------------------
// | Copyright(c)2009 http://www.tommyframework.com All rights reserved.
// +---------------------------------------------------------------
// | Author: tommy <service@tommyframework.com>
// +---------------------------------------------------------------

/**
 +-------------------------------------------------------------------
 * Tommy Framework应用程序类 页面缓存处理
 +-------------------------------------------------------------------
 */

if(!defined('IN_TOMMY')){
	exit;
}
class Cache extends Base{
	
	//定义变量.
	private static $instance; //用于构建类的singleton模式参数
	public $cache_dir;	//缓存文件存放目录.
	public $lifetime;	//缓存文件存在周期时间.
	public $cache_on;	//缓存文件重写开关,默认关闭.	
	protected $filters;	//网址过滤参数.
	protected $cache_file;	//缓存文件.
	
	/**
     +----------------------------------------------------------
     * 构造函数,用于初始化运行环境.
     +----------------------------------------------------------
     * @access public
     +----------------------------------------------------------
     * @return mixed
     +----------------------------------------------------------
     */
	public function __construct(){
		//初始化变量.
		$this->cache_dir = APP_ROOT.'/cache/template/'.strtolower(substr(Tommy::$controller, 0, -10));
		$this->cache_on = false;
		$this->lifetime = 10;
		return true;
	}
	
	/**
     +----------------------------------------------------------
     * 分析缓存文件.
     +----------------------------------------------------------
     * @access public
     +----------------------------------------------------------
     * @return string
     +----------------------------------------------------------
     */
	protected function parse_cache_file(){		
		if(!$this->cache_file){
			$action_name = substr(Tommy::$action, 0, -6);
			//处理action之后的url有效部分.
			$url_str = '';
			if($this->filters){
				foreach ($this->filters as $name){
					$name_value = htmlspecialchars(trim($_GET[$name]));
					if($name_value)
					$url_str .= '/'.$name.'/'.$name_value;
				}
			}
			$file_name = ($url_str) ? $action_name.$url_str : $action_name;
			$this->cache_file = $this->cache_dir.'/'.md5($file_name).'.html';
		}		
		return $this->cache_file;
	}
	
	/**
     +----------------------------------------------------------
     * 对URL过滤参数处理.
     +----------------------------------------------------------
     * @access public
     +----------------------------------------------------------
     * @return class
     +----------------------------------------------------------
     */
	public function filter($params){
		//参数分析.
		if(empty($params)||!is_array($params))
		return false;		
		$this->filters = $params;
		return $this;
	}
	
	/**
     +----------------------------------------------------------
     * 设置缓存周期时间.
     +----------------------------------------------------------
     * @access public
     +----------------------------------------------------------
     * @return class
     +----------------------------------------------------------
     */
	public function lifetime($expire=false){
		//参数分析.
		if(empty($expire))
		$this->lifetime = 10;		
		$this->lifetime = $expire;
		return $this;
	}
	
	/**
     +----------------------------------------------------------
     * 判断缓存文件是否需要重新写入.
     +----------------------------------------------------------
     * @access public
     +----------------------------------------------------------
     * @return mixed
     +----------------------------------------------------------
     */
	protected function check_cache_file(){
		//获取缓存文件.
		$this->parse_cache_file();
		if(file_exists($this->cache_file)){
			$this->cache_on = ($_SERVER['REQUEST_TIME']-filemtime($this->cache_file)>$this->lifetime) ? true : false;
		}
		else {
			$this->cache_on = true;
		}
		return $this->cache_on;
	}
	
	/**
     +----------------------------------------------------------
     * 加载缓存文件.
     +----------------------------------------------------------
     * @access public
     +----------------------------------------------------------
     * @return mixed
     +----------------------------------------------------------
     */
	public function load_cache(){
		//判断缓存文件是否重写.
		$this->check_cache_file();		
		if($this->cache_on==false){
			include($this->cache_file);
			exit();
		}
		return true;
	}
	
	/**
     +----------------------------------------------------------
     * 创建缓存文件
     +----------------------------------------------------------
     * @access public
     +----------------------------------------------------------
     * @param string $params 类的名称
     +----------------------------------------------------------
     * @return mixed
     +----------------------------------------------------------
     */
	public function create_cache($content){
		//参数分析.
		if(empty($content))
			return false;		
		//分析缓存目录是否存在.
		if(!is_dir($this->cache_dir))
			mkdir($this->cache_dir, 0777);
		//分析缓存文件.
		$this->parse_cache_file();
		//向缓存文件写入内容.
		file_put_contents($this->cache_file, $content, LOCK_EX);
		return true;
	}

	/**
     +----------------------------------------------------------
     * 用于本类的静态调用,子类需要重载才能正常使用.
     +----------------------------------------------------------
     * @access public
     +----------------------------------------------------------
     * @param string $params 类的名称
     +----------------------------------------------------------
     * @return void
     +----------------------------------------------------------
     */
    public static function getInstance(){		
		if(self::$instance == null){
			self::$instance = new self;
		}
		return self::$instance;
	}
}
?>