<?php
// +---------------------------------------------------------------
// | Package: Tommy Framework
// +---------------------------------------------------------------
// | Version $Id: Log.class.php 2010-3-30 12:30:30 $
// +---------------------------------------------------------------
// | Copyright (c) 2009 http://www.tommyframework.com All rights reserved.
// +---------------------------------------------------------------
// | Author: tommy <service@tommyframework.com>
// +---------------------------------------------------------------

/**
 +------------------------------------------------------------------------------
 * Tommy FrameworkAction日志管理(写入)
 +------------------------------------------------------------------------------ 
 */

if(!defined('IN_TOMMY')){
	exit;
}
class Log extends Base{
	/**
     +----------------------------------------------------------
     * 日志写入
     +----------------------------------------------------------
     * @param string $message 日志内容
     * @param string $leverl 日志类型
     * @param string $log_file_name 日志文件
     +----------------------------------------------------------
     * @return mixed
     +----------------------------------------------------------
     */
	public function write($message, $leverl='Error', $log_file_name=false){		
		$time_now = date('[Y-m-d H:i:s]', time());
		if(empty($log_file_name)){
			$log_file_name = APP_ROOT.'/logs/'.date('Y_m_d', time()).'.log';
		}
		//检查日志文件是否超过最大允许大小
		if(file_exists($log_file_name) && (filesize($log_file_name) >= 2097152)){
			rename($log_file_name, APP_ROOT.'/logs/'.time().'-'.basename($log_file_name));
		}
		error_log("{$time_now} {$leverl}: {$message}\r\n", 3, $log_file_name);
	}
}
?>