<?php
// +---------------------------------------------------------------
// | Package: Tommy Framework
// +---------------------------------------------------------------
// | Version $Id:calendar.class.php 2010-3-30 12:30:30 $
// +---------------------------------------------------------------
// | Copyright (c) 2009 http://www.tommyframework.com All rights reserved.
// +---------------------------------------------------------------
// | Author: tommy <service@tommyframework.com>
// +---------------------------------------------------------------

if(!defined('IN_TOMMY')){
	exit;
}
class calendar extends Base {
	
	//定义变量	
	public $html;	//处理完毕的HTML分页代码
	
	/**
     +----------------------------------------------------------
     * 构造函数,用于初始化运行环境.
     +----------------------------------------------------------
     * @access public
     +----------------------------------------------------------
     * @return mixed
     +----------------------------------------------------------
     */
	public function __construct(){
		
	}
	
	//显示日历.
	public function output($year=FALSE, $month=FALSE){		
		//获得当前时间戳
		$time_now = isset($_SERVER['REQUEST_TIME']) ? $_SERVER['REQUEST_TIME'] : time();
		$year = empty($year) ? date('Y', $time_now) : $year;
		$month = empty($month) ? date('m', $time_now) : $month;		
		$year_now = date('Y',$time_now);
		$month_now = date('m',$time_now);
		$date_now = date('j', $time_now);		
		$time_index = mktime(0, 0, 0, $month, 1, $year);		
		//获取当前所在月份的总天数，第一天的星期数.
		$total_days = date('t', $time_index);
		$day_index = date('w', $time_index);		
		//计算日历的总行数。
		$total_lines = ceil( ($total_days + $day_index)/7 );		
		$html =<<<EOT
<!-- calendar begin -->
<table class="calendar">
<tr><td colspan="7" class="message">$year 年  $month 月</td></tr>
<tr class="menu">
  <td>日</td>
  <td>一</td>
  <td>二</td>
  <td>三</td>
  <td>四</td>
  <td>五</td>
  <td>六</td>
</tr>\r\n
EOT;

		for ($i=0; $i<$total_lines; $i++){			
			$html .= "<tr align=\"center\">\r\n";
			for ($k=0; $k<7; $k++){				
				$date_show = intval( 7*$i + $k - $day_index + 1);
				if(($date_show < 1)||($date_show>$total_days)){					
					$html .= "<td>&nbsp;</td>\r\n";
				}
				else
				{
					$html .= (($date_show==$date_now)&&($month_now==$month)&&($year_now==$year)) ? "<td class=\"today\">" . $date_show . "</td>\r\n" : "<td>" . $date_show . "</td>\r\n";
				}
			}
			$html .= "</tr>\r\n";
		}
		$html .= "</table>\r\n<!-- calendar end -->\r\n";		
		$this->html = $html;
		return $this;
	}
	
	//模板赋值
	public function assign($tag_name){		
		if(empty($tag_name)){
			return false;
		}
		return Controller::assign($tag_name, $this->html);
	}

	//加载pagelist的CSS文件
	public function addcss(){
		$css_file = (TOMMY_URL==true)? TOMMY_URL : Controller::get_base_url().str_replace('\\', '/', str_replace(APP_ROOT, '', TOMMY_ROOT));
		$css_file .= '/views/images/calendar.min.css';
		$this->html = html::css_file($css_file);
		return $this;
	}

	//构晰函数
	public function __destruct(){		
		if(isset($this->html)){			
			unset($this->html);
		}
	}
	
	//输出本类信息 方便程序直接对实例化对象进行调用
	public function __toString(){		
		if($this->html){			
			return (string)$this->html;
		}
		else{			
			return (string)'This is Calendar Class';
		}
	}
}