<?php
// +---------------------------------------------------------------
// | Package: Tommy Framework
// +---------------------------------------------------------------
// | Version $Id:cookie.class.php 2010-3-30 12:30:30 $
// +---------------------------------------------------------------
// | Copyright (c) 2009 http://www.tommyframework.com All rights reserved.
// +---------------------------------------------------------------
// | Author: tommy <service@tommyframework.com>
// +---------------------------------------------------------------

if(!defined('IN_TOMMY')){
	exit;
}
class cookie extends Base{	

	//判断cookie是否存在.
	public static function is_set($name){
		return isset($_COOKIE[$name]);
	}
	
	// 获取某个Cookie值.
	public static function get($name){
		$value = $_COOKIE[$name];
		$value = unserialize(base64_decode($value));
		return $value;
	}
	
	//设置某个Cookie值.
	public static function set($name,$value,$expire='',$path='',$domain=''){
		//参数分析.
		$expire = empty($expire) ? time()+3600 : time()+$expire;
		if (empty($path))
			$path = '/';
		//数据加密处理.	
		$value = base64_encode(serialize($value));
		setcookie($name, $value,$expire,$path,$domain);
		$_COOKIE[$name] = $value;		
	}
	
	//删除某个Cookie值
	public static function delete($name){
		self::set($name, '', '-3600');
		unset($_COOKIE[$name]);
	}
	
	// 清空Cookie值
	public static function clear(){
		unset($_COOKIE);
	}
}
?>