<?php
// +---------------------------------------------------------------
// | Package: Tommy Framework
// +---------------------------------------------------------------
// | Version $Id:html.class.php 2010-3-30 12:30:30 $
// +---------------------------------------------------------------
// | Copyright (c) 2009 http://www.tommyframework.com All rights reserved.
// +---------------------------------------------------------------
// | Author: tommy <service@tommyframework.com>
// +---------------------------------------------------------------

if(!defined('IN_TOMMY')){
	exit;
}
class regexp extends Base{
	
	//正则表达式验证email格式。
	public function is_email($str){
		if(empty($str)){
			return false;
		}
		if(preg_match('#[a-z0-9&\-_.]+@[\w\-_]+([\w\-.]+)?\.[\w\-]+#is', $str)){
			return true;
		}else{
			return false;
		}
	}

	//正则表达式验证网址。
	public function is_url($str){
		if(empty($str)){
			return false;
		}
		if(preg_match('#(http|https|ftp|ftps)://([\w-]+\.)+[\w-]+(/[\w-./?%&=]*)?#i', $str)){
			return true;
		}else{
			return false;
		}
	}

	//正则表达式验证QQ号。
	public function is_qq($num){
		if(empty($num)){
			return false;
		}
		if(preg_match('#^[1-9][0-9]{4,}$#', $num)){
			return true;
		}else{
			return false;
		}
	}

	//用正则表达式验证邮证编码。
	public function is_post_num($num){
		if(empty($num)){
			return false;
		}
		if(preg_match('#^[1-9][0-9]{5}$#', $num)){
			return true;
		}else{
			return false;
		}
	}

	//正则表达式验证身份证号码。
	public function is_person_card($num){
		if(empty($num)){
			return false;
		}
		if(preg_match('#^[\d]{15}$|^[\d]{18}$#', $num)){
			return true;
		}else{
			return false;
		}
	}

	//正则表达式验证IP地址。用于IPv4,IPV6不支持。
	public function is_ip($str){
		if(empty($str)){
			return false;
		}
		if(preg_match('#^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$#', $str)){
			$ip_array = explode('.', $str);
			//真实的ip地址每个数字不能大于255（0-255）。
			if($ip_array[0]<=255&&$ip_array[1]<=255&&$ip_array[2]<=255&&$ip_array[3]<=255){
				return true;
			}else{
				return false;
			}			
		}else{
			return false;
		}
	}

	//用正则表达式验证出版物的ISBN号。
	public function is_book_isbn($str){
		if(empty($str)){
			return false;
		}
		if(preg_match('#^978[\d]{10}$|^978-[\d]{10}$#', $str)){
			return true;
		}else{
			return false;
		}
	}

	//用正则表达式验证手机号码(中国大陆区)。
	public function is_mobile($num){
		if(empty($num)){
			return false;
		}
		if(preg_match('#^13[\d]{9}$|^15[0-35-9]\d{8}$|^18[05-9]\d{8}$#', $num)){
			return true;
		}else{
			return false;
		}
	}
}
?>