<?php
// +---------------------------------------------------------------
// | Package: Tommy Framework
// +---------------------------------------------------------------
// | Version $Id:script.class.php 2010-3-30 12:30:30 $
// +---------------------------------------------------------------
// | Copyright (c) 2009 http://www.tommyframework.com All rights reserved.
// +---------------------------------------------------------------
// | Author: tommy <service@tommyframework.com>
// +---------------------------------------------------------------

if(!defined('IN_TOMMY')){
	exit;
}
class script extends Base{

	//定义变量
	public  $base_url;	//当前执行文件的目录，绝对路径
	public  $html;
	public  static $instance; //用于构建类的singleton模式参数
	
	//构造函数
	public function __construct(){		
		return $this->base_url = (TOMMY_URL==true) ? TOMMY_URL : Controller::get_base_url().str_replace('\\', '/', str_replace(APP_ROOT, '', TOMMY_ROOT));
	}
	
	//加载js文件
	public function add($script_name){	
		$script_name = strtolower(trim($script_name));
		if(empty($script_name)){
			return false;
		}		
		/*if(!in_array($script_name, array('jquery', 'thickbox', 'calendar'))){
			
			return false;
		}*/
		switch ($script_name){			
			case 'jquery':
				if(file_exists(TOMMY_ROOT.'/vendors/jquery/jquery.min.js')){					
					$jquery_url = $this->base_url.'/vendors/jquery/jquery.min.js';
				}
				else{					
					$jquery_url = 'http://ajax.googleapis.com/ajax/libs/jquery/1.4/jquery.min.js';
				}
				$this->html = "<script type=\"text/javascript\" src=\"".$jquery_url."\"></script>\r";
				break;				
			case 'thickbox':
				$this->html = "<script type=\"text/javascript\">if(typeof tb_pathToImage!='string'){var tb_pathToImage=\"".$this->base_url."/vendors/thickbox/loading.gif\"}</script>\r<script type=\"text/javascript\" src=\"".$this->base_url."/vendors/thickbox/thickbox.min.js\"></script>\r<link href=\"".$this->base_url."/vendors/thickbox/thickbox.css\" rel=\"stylesheet\" type=\"text/css\" />\r";
				break;				
			case 'calendar':
				$this->html = "<script type=\"text/javascript\" src=\"".$this->base_url."/vendors/calendar/date.min.js\"></script>\r<script type=\"text/javascript\" src=\"".$this->base_url."/vendors/calendar/jquery.datePicker.min-2.1.2.js\"></script>\r<link href=\"".$this->base_url."/vendors/calendar/datePicker.min.css\" rel=\"stylesheet\" type=\"text/css\" />\r";
				break;
			case 'form':
				$this->html = "<script type=\"text/javascript\" src=\"".$this->base_url."/vendors/jquery/jquery.form.min.js\"></script>\r";
				break;
			case 'tabs':
				$this->html = "<script type=\"text/javascript\" src=\"".$this->base_url."/vendors/jquery/jquery.tabs.min.js\"></script>\r";
				break;
			case 'tooltip':
				$this->html = "<script type=\"text/javascript\" src=\"".$this->base_url."/vendors/jquery/jquery.tooltip.min.js\"></script>\r";
				break;
			case 'checkbox':
				$this->html = "<script type=\"text/javascript\" src=\"".$this->base_url."/vendors/jquery/jquery.checkbox.js\"></script>\r";
				break;
			case 'ajax_loading':
				$this->html = "<script type=\"text/javascript\">\$(document).ready(function(){\$('#tommy_ajax_load').fadeOut('slow');});</script>\r<link href=\"".$this->base_url."/views/images/tommy_ajax_load.min.css\" rel=\"stylesheet\" type=\"text/css\"/>\r";
				break;
			default:
				$this->html = "<script type=\"text/javascript\" src=\"".$script_name.".js\"></script>\r";
		}
		return $this;
	}
	
	//MP3 PLAYER JS脚本函数(flash 的MP3播放器)
	public function mp3Player($file_url, $width=false, $height=false, $autoplay=false){
		
		$width = empty($width) ? 290 : $width;
		$height = empty($height) ? 24 : $height;
		$autoplay = ($autoplay==true) ? 'true' : 'false';

		$this->html =<<<EOT
<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,19,0" width="{$width}" height="{$height}">
<param name="movie" value="{$this->base_url}/views/images/mp3.swf?soundFile={$file_url}&autostart={$autoplay}&loop=yes" />
<param name="quality" value="high" />
<param value="transparent" name="wmode" />
<embed src="{$this->base_url}/views/images/mp3.swf?soundFile={$file_url}&autostart={$autoplay}&loop=yes" width="{$width}" height="{$height}" quality="high" pluginspage="http://www.macromedia.com/go/getflashplayer" type="application/x-shockwave-flash">
</embed>
</object>
EOT;
		return $this;
	}
	
	//FLV PLAYER JS脚本
	public function flvPlayer($file_url, $width=false, $height=false, $autoplay=true){		
		$width = empty($width) ? 400 : $width;
		$height = empty($height) ? 300 : $height;
		$autoplay = ($autoplay==false) ? 'false' : 'true';

		$this->html=<<<EOT
			<object type="application/x-shockwave-flash" data="{$this->base_url}/views/images/vcastr3.swf" width="{$width}" height="{$height}" id="vcastr3">
			<param name="movie" value="{$this->base_url}/views/images/vcastr3.swf"/> 
			<param name="allowFullScreen" value="true"/>
			<param name="FlashVars" value="xml=
				<vcastr>
					<channel>
						<item>
							<source>{$file_url}</source>
						</item>
					</channel>
					<config>
						<bufferTime>4</bufferTime>
						<isAutoPlay>{$autoplay}</isAutoPlay>
						<isShowAbout>false</isShowAbout>
						<isLoadBegin>true</isLoadBegin>
						<isRepeat>false</isRepeat>
					</config>
				</vcastr>"/>
		</object>
EOT;
		return $this;
	}

	//幻灯片效果 JS脚本.
	/*参数说明:$file_url:
	array(
		array('link'=>'http://www.tommyframework.com', 'pic'=>'/logo.jpg', 'text'=>'tommy framework'),
		array('link'=>'http://www.tommyframework.com', 'pic'=>'/logo1.jpg', 'text'=>'bese php framework'),
		array('link'=>'http://www.tommyframework.com', 'pic'=>'/logo3.jpg', 'text'=>'very easy framwork')
	);*/
	public function flash_slide($file_url, $width=false, $height=false){
		//参数判断.
		if(empty($file_url)||!is_array($file_url)||!is_array($file_url[0])){
			return false;
		}
		$content_str="\r\n";
		foreach($file_url as $keys=>$lines){
			$key = $keys+1;
			$content_str.="linkarr[{$key}]=\"{$lines['link']}\";\r\npicarr[{$key}]= \"{$lines['pic']}\";\r\ntextarr[{$key}]=\"{$lines['text']}\";\r\n";
		}
		//幻灯片的宽度和高度.
		$width = empty($width) ? 280 : $width;
		$height = empty($height) ? 192 : $height;
		$this->html=<<<EOT
<script language='javascript'>
linkarr = new Array();
picarr = new Array();
textarr = new Array();
var swf_width={$width};
var swf_height={$height};
var files = "";
var links = "";
var texts = "";
{$content_str}
for(i=1;i<picarr.length;i++){
  if(files=="") files = picarr[i];
  else files += "|"+picarr[i];
}
for(i=1;i<linkarr.length;i++){
  if(links=="") links = linkarr[i];
  else links += "|"+linkarr[i];
}
for(i=1;i<textarr.length;i++){
  if(texts=="") texts = textarr[i];
  else texts += "|"+textarr[i];
}
document.write('<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0" width="'+ swf_width +'" height="'+ swf_height +'">');
document.write('<param name="movie" value="{$this->base_url}/views/images/bcastr3.swf"><param name="quality" value="high">');
document.write('<param name="menu" value="false"><param name=wmode value="opaque">');
document.write('<param name="FlashVars" value="bcastr_file='+files+'&bcastr_link='+links+'&bcastr_title='+texts+'">');
document.write('<embed src="{$this->base_url}/views/images/bcastr3.swf" wmode="opaque" FlashVars="bcastr_file='+files+'&bcastr_link='+links+'&bcastr_title='+texts+'& menu="false" quality="high" width="'+ swf_width +'" height="'+ swf_height +'" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" />'); document.write('</object>'); 
</script>
EOT;
	return $this;
	}
	
	//用于处理jquery的ajax post代码. 注:非$.post,而是$.ajax。
	public function ajax_post($url, $data=false, $beforeSend=false, $success=false){
		//参数判断.
		if(empty($url)){
			return false;
		}
		$this->html = "\$.ajax({url:'{$url}',type:'POST',";
		if($data){
			$this->html .= is_array($data) ? "data:'".http_build_query($data)."'," : "data:'{$data}',";
		}
		if($beforeSend){
			$this->html .= "beforeSend:{$beforeSend},";
		}
		if($success){
			$this->html .= "success:{$success},";
		}
		$this->html .= "});\r";
		return $this;
	}

	//用于处理jquery的ajax GET代码. 注:非$.get,而是$.ajax。
	public function ajax_get($url, $data=false, $beforeSend=false, $success=false){
		//参数判断.
		if(empty($url)){
			return false;
		}
		$this->html = "\$.ajax({url:'{$url}',type:'GET',";
		if($data){
			$this->html .= is_array($data) ? "data:'".http_build_query($data)."'," : "data:'{$data}',";
		}
		if($beforeSend){
			$this->html .= "beforeSend:{$beforeSend},";
		}
		if($success){
			$this->html .= "success:{$success},";
		}
		$this->html .= "});\r";
		return $this;
	}

	//整天Ajax Loading 加载图片的HTML代码.@small为小图片.
	public function ajax_loading_image($options='small'){		
		switch($options){
			case 'small':
				$image_name = 'ajax_loading_small.gif';
				break;
			case 'big':
				$image_name = 'ajax_loading_big.gif';
				break;
			case 'bar':
				$image_name = 'ajax_loading_bar.gif';
				break;
			case 'snake':
				$image_name = 'ajax_loading_snake.gif';
				break;
			case 'ring':
				$image_name = 'ajax_loading_ring.gif';
				break;
			default : $image_name = 'ajax_loading_small.gif';
		}
		$this->html = '<img src="'.$this->base_url.'/views/images/'.$image_name.'"/>';
		return $this;				
	}	

	//页面加载ajax loading 图片的HTML代码.
	public function ajax_loading_html(){
		$this->html = "<div id='tommy_ajax_load'><span><img src='/tommy/views/images/ajax_loading_small.gif'/></span><span>页面载入中,请稍后...</span></div><div id='tommy_load_clear'></div>\r";
		return $this;
	}

	//处理$.load()的jquery代码.
	public function ajax_box_load($tag, $url, $image_option='small'){
		//参数分析.
		if(empty($tag)||empty($url)){
			return false;
		}
		//选择ajax loading image 的类型.
		switch($image_option){
			case 'small':
				$image_name = 'ajax_loading_small.gif';
				break;
			case 'big':
				$image_name = 'ajax_loading_big.gif';
				break;
			case 'bar':
				$image_name = 'ajax_loading_bar.gif';
				break;
			case 'snake':
				$image_name = 'ajax_loading_snake.gif';
				break;
			case 'ring':
				$image_name = 'ajax_loading_ring.gif';
				break;
			default : $image_name = 'ajax_loading_small.gif';
		}
		//JS代码赋值.
		$this->html = "<script type=\"text/javascript\">\$(document).ready(function(){\$('".$tag."').append('<img src=\"".$this->base_url."/views/images/".$image_name."\" id=\"tommy_ajax_loading_image\"/>');var left=parseInt((\$('".$tag."').width()-\$('#tommy_ajax_loading_image').width())/2);var top=parseInt((\$('".$tag."').height()-\$('#tommy_ajax_loading_image').height())/2);\$('#tommy_ajax_loading_image').css({'margin-top':top+'px','margin-left':left+'px'});\$('".$tag."').load('".$url."',function(){\$('#tommy_ajax_loading_image').remove()})});</script>\r";
		return $this;
	}

	//日历的调用,JS代码.
	public function calendar($tag, $start_date=false, $end_date=false){
		//参数分析.
		if(empty($tag)){
			return false;
		}
		$calendar_params = 'clickInput:true';
		if($start_date){
			$calendar_params .= ',startDate:\''.$start_date.'\'';
		}
		if($end_date){
			$calendar_params .= ',endDate:(new Date()).asString()';
		}
		$this->html ="<script type=\"text/javascript\">\$(document).ready(function(){\$('".$tag."').datePicker({".$calendar_params."})});</script>\r";
		return $this;
	}

	//模板赋值
	public function assign($tag_name){		
		if(empty($tag_name)){
			return false;
		}
		return Controller::assign($tag_name, $this->html);
	}

	//输出本类信息 方便程序直接对实例化对象进行调用
	public function __toString(){		
		if($this->html){			
			return (string)$this->html;
		}
		else{			
			return (string)'This is Script Class';
		}
	}
	
	//构晰函数
	public function __destruct(){		
		if(isset($this->html)){
			unset($this->html);
		}
	}

	/**
     +----------------------------------------------------------
     * 用于本类的静态调用,子类需要重载才能正常使用.
     +----------------------------------------------------------
     * @access public
     +----------------------------------------------------------
     * @param string $params 类的名称
     +----------------------------------------------------------
     * @return void
     +----------------------------------------------------------
     */
    public static function getInstance(){		
		if(self::$instance == null){		
			self::$instance = new self;
		}		
		return self::$instance;
	}
}
?>