<?php
// +---------------------------------------------------------------
// | Tommy Framework
// +---------------------------------------------------------------
// | Copyright (c) 2009 http://www.tommycode.com All rights reserved.
// +---------------------------------------------------------------
// | Author: streen003 <streen003gmail.com>
// +---------------------------------------------------------------

if(!defined('IN_TOMMY')){

	exit;
}

abstract class Base {
	
	//定义变量
	protected static $instance; //用于构建类的singleton模式参数

	//自动变量设置
    public function __set($name ,$value)
    {
        if(property_exists($this,$name)){
           
			$this->$name = $value;
        }
    }

	//自动变量获取
    public function __get($name)
    {
        if(isset($this->$name)){
            
			return $this->$name;
        }
		else {
            
			return false;
        }
    }
	
	//处理当类外调用不存在的方法
	public function __call($method,array $args) {

		echo 'Method:'.$method.'() is not exists in Class:'.get_class($this).'!<br>The args is:<br>';
		
		foreach ($args as $val) {
			
			echo $val.'<br>';
		}
	}

	//直接调用函数，输出内容
	public function __toString() {

		 return (string)'This is '.get_class($this).' Class!';
	 }

	//用于本类的静态调用,子类需要重载才能正常使用.
    public static function getInstance(){
		
		if (self::$instance == null) {
		
			self::$instance = new self;
		}
		
		return self::$instance;
	}
}
?>