<?php
class MakeModel {

	private 	$db_link; 	//数据库连接实例化。
	protected 	$data;		//数据库内数据表名LIST。

	public 		$fileroot; //生成文件的目录。
	public 		$file;		//生成文件。
	public		$file_name; //生成的文件名。
	public		$content;	//文件的内容。

	//构造函数，用于初始化运行环境
	public function __construct() {

		global $config;

		$this->db_link = Db::getInstance($config);

		return $this->db_link;
	}

	//获取数据库内的总数据表
	protected function get_data() {

		$sql = 'SHOW TABLES';

		$this->data = $this->db_link->get_array($sql);

		return $this->data;
	}

	//检查生成文件的目录设置
	public function parse_FileRoot() {

		if(!$this->fileroot) {
				
			$this->fileroot = APP_ROOT.'models/';
		}

		if(!is_dir($this->fileroot)) {
				
			mkdir($this->fileroot, 0777);
		}

		return $this->fileroot;
	}

	//生成MODEL文件函数
	public function create_file($table_name) {

		$table_name = ucfirst(strtolower($table_name));

		$this->file_name[$table_name] = $table_name.'Model.class.php';

		$this->file[$table_name] = $this->fileroot.$this->file_name[$table_name];

		if(file_exists($this->file[$table_name])) {
				
			return false;
		}
		else {
				
			$this->content[$table_name] = "<?php\r\nclass ".$table_name."Model extends Model {\r\n\r\n}\r\n?>";

			file_put_contents($this->file[$table_name], $this->content[$table_name], LOCK_EX);

			return true;
		}
	}

	//生成全部的MODEL文件，本类的主函数
	public function run() {

		global $config;		//数据库连接信息

		if(!$this->data) {
				
			$this->get_data();
		}

		$this->parse_FileRoot();

		foreach($this->data as $value) {
				
			$table_name = $value['Tables_in_'.$config['dbname']];

			if(!empty($config['prefix'])){

				$table_name = str_replace($config['prefix'], '', $table_name);
			}
				
			$this->create_file($table_name);
		}

		return true;
	}

	//晰构函数，用于程序运行完打扫战场
	public function __destruct() {

		if($this->data) {
				
			unset($this->data);
		}
	}
}