<?php
define('APP_ROOT', substr(dirname(__FILE__), 0, -10));
//项目目录名数组.
$app_dir_array = array(
'views',
'themes',
'themes/error',
'themes/default',
'themes/default/images',
'models',
'controllers',
'cache',
'cache/template',
'cache/template_c',
'cache/data',
'cache/model',
'cache/temp',
'cache/widget',
'widgets',
'widgets/views',
'config',
'logs',
'extensions',
'upload',
'upload/file',
'upload/flash',
'upload/images',
'upload/_thumbs',
'upload/_thumbs/Images',
'upload/_thumbs/Flash',
);
//生成目录.
foreach($app_dir_array as $name){
	create_app_dir($name);
}

//生成项目目录函数.
function create_app_dir($dir_name){
	if(empty($dir_name)){
		return false;
	}
	$dir = APP_ROOT.$dir_name;
	if(!is_dir($dir)){
		mkdir($dir, 0777);
		copy('index.php', $dir.'/index.php');
	}

	return true;
}
//生成index.php文件
if(!file_exists(APP_ROOT.'index.php')){

	$file_content_index = "<?php\r\n// +---------------------------------------------------------------\r\n// |	Tommy FrameWork\r\n// +---------------------------------------------------------------\r\n// | Copyright (c) 2009 http://www.tommycode.com All rights reserved.\r\n// +---------------------------------------------------------------\r\n// | Author: streen003 <streen003gmail.com>\r\n// +---------------------------------------------------------------\r\n\r\ndefine('IN_TOMMY', true);\r\n\r\n//define('TOMMY_REWRITE', true);\r\n//define('TOMMY_DEBUG', true);\r\n\r\ndefine('APP_ROOT', dirname(__FILE__));\r\n\r\n//define('TOMMY_URL', '/tommy');\r\n\r\n//define('TOMMY_TIMEZONE', 'Asia/ShangHai');\r\n\r\ninclude APP_ROOT.'/tommy/Tommy.class.php';\r\n\r\nTommy::Run();\r\n?>";

	file_put_contents(APP_ROOT.'index.php', $file_content_index, LOCK_EX);
}

//目录.htaccess文件
if(!file_exists(APP_ROOT.'.htaccess')){

	$file_content_htaccess = <<<EOT
RewriteEngine On
RewriteCond %{REQUEST_FILENAME} -s [OR]
RewriteCond %{REQUEST_FILENAME} -l [OR]
RewriteCond %{REQUEST_FILENAME} -d
RewriteRule ^.*$ - [NC,L]
RewriteRule ^.*$ index.php [NC,L]
EOT;

	file_put_contents(APP_ROOT.'.htaccess', $file_content_htaccess, LOCK_EX);
}

if(!file_exists(APP_ROOT.'robots.txt')){
	$file_content_robots= <<<EOT
User-agent: *
Crawl-delay: 10
Disallow: /tommy/
Disallow: /tools/
Disallow: /config/
Disallow: /controllers/
Disallow: /models/
Disallow: /widgets/
Disallow: /themes/
Disallow: /views/
Disallow: /extensions/
Disallow: /logs/
EOT;
	file_put_contents(APP_ROOT.'robots.txt', $file_content_robots, LOCK_EX);
}
echo '系统目录生成完毕!';
?>