<?php   if ( ! defined('FIT_PATH')) exit('No direct script access allowed');
/**
 * @copyright 2009 - 2010 Bincent.com. All Rights Reserved.
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @package FitPHP
 * @subpackage core
 * 
 * @author Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version $Id: core/application.php 1.0 2009-07-18 13:34 hongbin.hsu $
 */
 
// ------------------------------------------------------------------------

require_once('base.php');

class Application extends Base
{
	protected	$module			= null;
	protected	$control_path	= 'controller/';
	private		$control		= 'start';
	private		$action			= 'index';
	private 	$splits			= array();
	
	public function __construct($config = null){
		if (!is_null($config)) {
			if (is_array($config)) {
				$this->module = $config;
			}else{
				$this->module['default'] = $config;
			}
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 重定义控制器名称
	 *
	 * @param string $control 控制器名称
	 */
	public function set_default_controller($control){
		$this->control = strtolower($control);
	}
	
	//----------------------------------------------------------
	/**
	 * 重定义方法名称
	 *
	 * @param string $action 方法名称
	 */
	public function set_default_action($action){
		$this->action = strtolower($action);
	}
	
	//----------------------------------------------------------
	/**
	 * 添加模块
	 *
	 * @param string $directory
	 * @param string $module
	 */
	public function add_directory($directory, $module = null) {
		$this->module[$module] = $directory;
	}
	
	//----------------------------------------------------------
	/**
	 * 执行应用程序
	 *
	 */
	public  function execute() {
		try {
			$this->dispatcher();
			
	        $control = strtolower($this->control);
	        $object  = preg_replace('/_(.)/e',"'_'.ucfirst('\\1')", ucfirst($control));
	        $action  = strtolower($this->action);
	        
	        $control_path = APP_PATH.DIRECTORY_SEPARATOR;
	        if (defined('FIT_MODULE')) {
	        	$control_path .= FIT_MODULE.DIRECTORY_SEPARATOR;
	        }
	        
	        $controlfile = $control_path.$this->control_path.$control.'.php';
	        
	        if (is_file($controlfile)) {
	        	include_once($controlfile);
	        	if (class_exists($object)) {
		        	$app = new $object();
		        	$app->$action(implode(',', $this->splits));
		        }else{
		        	throw new Exception("not find {$object}");
		        }
	        }else{
	        	throw new Exception("not find {$controlfile}");
	        }
		}catch (Exception $e){
			echo $e->getMessage();
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 解析URL路径取得控制器与方法名
	 *
	 * @param string $control
	 * @param string $action
	 * @return void
	 */
	private function dispatcher()
	{
		$request_url = str_replace($_SERVER['SCRIPT_NAME'],'',$_SERVER['REQUEST_URI']);
		$this->splits = explode('/', trim($request_url,'/'));
		
		if (!is_null($this->module)) {
			$module = addslashes(array_shift($this->splits));
			if (isset($this->module[$module])) {
				$directory = $this->module[$module];
			} else {
				$directory = $this->module['default'];
			}
			define('FIT_MODULE', trim($directory, '/'));
		}
		
		$control = addslashes(array_shift($this->splits));
		$action = addslashes(array_shift($this->splits));
		$this->control = !empty($control) ? $control : $this->control ;
		$this->action = !empty($action) ? $action : $this->action;
		
		/**
		$cnt = count($this->splits);
        for ($i = 0; $i < $cnt; $i++) {
        	$key	= $this->splits[$i];
        	$value	= $this->splits[++$i];
            $_GET[$key] = isset($value) ? addslashes($key) : null;
        }
        **/
	}
}