<?php   if ( ! defined('FIT_PATH')) exit('No direct script access allowed');
/**
 * @copyright 2009 - 2010 Bincent.com. All Rights Reserved.
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @package FitPHP
 * @subpackage core
 * 
 * @author Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version $Id: core/database.php 1.0 2010-09-18 16:52 hongbin.hsu $
 */
 
// ------------------------------------------------------------------------

class Database
{	
	private static $instance = array();
	//private $config = array();
    private $driver = 'mysql';
    
    //----------------------------------------------------------
    /**
     * 关闭外部实例化
     */
	private function __construct(){}
   
    //----------------------------------------------------------
    /**
     * 静态化获得数据驱动实例化
     *
     * @param string $driver
     * @param array $config
     * @return object
     */
    public static function get_instance($type = 'default'){
    	if (is_null(self::$instance[$type])) {
    		$object = new self();
    		self::$instance[$type] = $object->initialize($type);
    	}
    	return self::$instance[$type];
    }
    
    //----------------------------------------------------------
    /**
     * 获取对应数据驱动实例化
     *
     * @return object
     */
    private function initialize($type){
    	try {
    		$config = $this->parse_config($type);
	    	if (isset($config['driver'])) {
	    		$this->driver = trim($config['driver']);
	    		unset($config['driver']);		//删除驱动元素
	    	}
	    	$this->driver = strtolower($this->driver);
	    	$driverfile = FIT_PATH."./database/{$this->driver}.php";
	    	require_once($driverfile); 
			$classname = 'database_'.$this->driver;
	        if(class_exists($classname) && is_file($driverfile)){
	        	$obj = new $classname($config);
	        	$obj->connect();
	        }else{
	        	throw new Exception('unfound database driver');
	        }
	        return $obj;
    	}catch (Exception $e){
    		echo $e->getMessage();
    	}
    }
    
    //----------------------------------------------------------
    /**
     * 解析ini配置文件
     *
     * @param string $type
     */
    private function parse_config($type) {
    	include_once(APP_PATH.DIRECTORY_SEPARATOR.'config/database.php');
        //$database = parse_ini_file('config/database.php',TRUE);
        return $database[$type];
    }
}