<?php   if ( ! defined('FIT_PATH')) exit('No direct script access allowed');
/**
 * @copyright 2009 - 2010 Bincent.com. All Rights Reserved.
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @package FitPHP
 * @subpackage core
 *
 * @author Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version $Id:$
 */
 
// ------------------------------------------------------------------------

class Loader
{
	public	$db			= null;
	public	$view		= null;
	public	$model		= null;

	//----------------------------------------------------------
	/**
	 * 加载数据库操作类
	 *
	 * @param string $db
	 */
	public function database($db = 'default'){
		$database_path = FIT_PATH.DIRECTORY_SEPARATOR;
		$database_path.= 'core'.DIRECTORY_SEPARATOR;
		require_once($database_path.'database.php');
		$this->db = Database::get_instance($db);
	}
	
	//----------------------------------------------------------
	/**
	 * 引用模板文件
	 *
	 * @param string $tpl 模板文件
	 * @param array $data 模板变量数组
	 */
	public function view($tpl = null, $data = array()){
		try {
        	$view_path = APP_PATH.DIRECTORY_SEPARATOR;
        	if (defined('FIT_MODULE')) {
	        	$view_path .= FIT_MODULE.DIRECTORY_SEPARATOR;
	        }
	        
        	$view_file = $view_path.'view'.DIRECTORY_SEPARATOR.ltrim($tpl, '/');
        	
        	if (is_file($view_file)) {
        		@extract($data, EXTR_SKIP);
				include_once($view_file);
        	}else{
        		throw new Exception("Not found {$tpl} template");
        	}
        }catch (Exception $e){
        	$e->getMessage();
        }
	}
	
	//----------------------------------------------------------
	/**
	 * 实例化业务模型
	 *
	 * @param file $model 模型名称
	 * @return mixed
	 */
	public function model($model, $alias = null){
		try {
			if (empty($model)) {return false;}
			$model	= strtolower($model);
			$object = preg_replace('/_(.)/e',"'_'.ucfirst('\\1')", ucfirst($model));
			$object.= '_Model';
			$model_path = APP_PATH.DIRECTORY_SEPARATOR;
			if (defined('FIT_MODULE')) {
	        	$model_path .= FIT_MODULE.DIRECTORY_SEPARATOR;
	        }
	        
			$filename = $model_path.'model'.DIRECTORY_SEPARATOR.$model.'.php';
			
			if (is_file($filename)) {
				require_once('model.php');
				include_once($filename);
				if (class_exists($object)) {
					if (!is_null($alias)){ $model = $alias;}
					$this->model->$model = new $object();
		        }else{
		        	throw new Exception("Not found {$object}");
		        }
			}else{
				throw new Exception("Not found {$filename} file.");
			}
		}catch (Exception $e){
			echo $e->getMessage();
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 加载功能类库
	 *
	 * @param string $library	功能类库名称
	 * @param array	$config		初始化数组
	 */
	public function library($library, $config = array()){
		try {
			if (empty($library)) { return false;}
			$library = strtolower($library);
			
			$library_path = FIT_PATH.DIRECTORY_SEPARATOR;
			$library_path.= 'library'.DIRECTORY_SEPARATOR;
			$library_file = $library_path.$library.'.php';
			
			if (!file_exists($library_file)) {
				throw new Exception("Not found {$library} library!");
			}
			require_once($library_file);
			$object = 'Library_'.ucfirst($library);
			$this->$library = new $object($config);
			
		}catch (Exception $e){
			echo $e->getMessage();
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 加载助手函数
	 *
	 * @param string $helper 助手函数文件名称
	 */
	public function helper($helper){
		try {
			if (empty($helper)) { return false;}
			$helper = strtolower($helper);
			
			$helper_path = FIT_PATH.DIRECTORY_SEPARATOR;
			$helper_path.= 'helper'.DIRECTORY_SEPARATOR;
			$helper_file = $helper_path.$helper.'.php';
			
			if (!file_exists($helper_file)) {
				throw new Exception("Not found {$helper} helper!");
			}
			
			require_once($helper_file);
		}catch (Exception $e){
			echo $e->getMessage();
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 加载第三方扩展
	 *
	 * @param string $extend 第三方扩展文件
	 */
	public function extend($extend){
		try {
			$extend_path = FIT_PATH.DIRECTORY_SEPARATOR;
			$extend_path.= 'extend'.DIRECTORY_SEPARATOR;
			$extend_file = $extend_path.ltrim($extend, '/');
			if (file_exists($extend_file)) {
				include_once($extend_file);
			}else{
				throw new Exception("Not found {$extend} extend file!");
			}
		}catch (Exception $e){
			echo $e->getMessage();
		}
	}
}