<?php   if ( ! defined('FIT_PATH')) exit('No direct script access allowed');
/**
 * @copyright 2009 - 2010 Bincent.com. All Rights Reserved.
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @package FitPHP
 * @subpackage core
 * 
 * @author Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version $Id: core/view.php 1.0 2010-09-18 16:52 hongbin.hsu $
 */
 
// ------------------------------------------------------------------------

class View
{
	private $data		= array();
	
	//----------------------------------------------------------
	/**
	 *  设置模板变量
	 *
	 * @param string $key
	 * @param mixed $value
	 */
	public function assign($key, $value = null){
		$this->data[$key] = $value;
	}
	
	//----------------------------------------------------------
    /**
     * 引用模板文件
     *
     * @param string $tpl
     */
	public function display($tpl = null, $data = array()) {
        try {
        	$view_path = APP_PATH.DIRECTORY_SEPARATOR.'views/';
        	$view_file = $view_path.$tpl;
        	if (is_file($view_file)) {
        		@extract($data, EXTR_SKIP);
        		@extract($this->data, EXTR_SKIP);
				include_once($view_file);
        	}else{
        		throw new Exception("unfound template:{$view_file}");
        	}
        }catch (Exception $e){
        	$e->getMessage();
        }
    }
}