<?php   if ( ! defined('FIT_PATH')) exit('No direct script access allowed');
/**
 * @copyright   Copyright (C) 2009 - 2010 fitphp.com
 * @license     New BSD License
 * @package		FitPHP
 * @subpackage	Database
 * 
 * @author      Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version     $Id: database/abstract.php 1.0 2010-09-18 16:52 hongbin.hsu $
 */
 
// ------------------------------------------------------------------------

abstract class Database_Abstract
{
	public $hostname = null;		//数据库服务器
    public $username = null;		//数据库帐号
    public $password = null;		//数据库密码
    public $database = null;		//数据库名称
    public $hostport = null;		//数据库端口
    public $charset = null;			//字符集
    public $dsn = null;				//DSN配置
    public $pconnect = false;		//是否使用持久连接
    protected $conn = null;			//数据库连接句柄
    protected $result = null;		//数据库结果集
    
    //----------------------------------------------------------
    
    public function __construct($config = array())
    {
    	if (!empty($config) && is_array($config)) {
    		foreach($config as $key => $value){
				$this->$key = $value;
			}
    	}
    }
    
    //----------------------------------------------------------
    /**
     * 插入数据库记录操作
     *
     * @param string $table
     * @param array $data
     * @return boolean
     */
    public function insert($table, $data = array()){
    	try {
    		if (!is_array($data)) {
    			throw new Exception("Insert {$table} data is not array.");
    		}
    		$insert = $values = null;
	        foreach ($data as $key => $value) {
	        	$insert .= $key . ',';
	        	$values .= "'". $value ."',";
	        }
	        $insert = rtrim($insert,',');
	        $values = rtrim($values,',');
	        $sql = "INSERT INTO {$table} ({$insert}) VALUES ({$values})";
	        return ($insert && $values) ? $this->query($sql): false;
    	}catch (Exception $e){
    		echo $e->getMessage();
    	}
    }
    
    //----------------------------------------------------------
    /**
     * 更新数据库记录操作
     *
     * @param string $table
     * @param array $data
     * @param string $where
     * @param int $limit
     * @return boolean
     */
    public function update($table, $data = array(), $where, $limit = 1){
    	try {
    		if (!is_array($data)) {
    			throw new Exception("Update {$table} data is not array!");
    		}
	    	$fields = null;
	        foreach ($data as $key => $value) {
	        	$fields .= " `" . $key . "` = '" . $value . "',";
	        }
	        $fields = rtrim($fields,',');
	        $limit  = intval($limit);
			$sql = "UPDATE {$table} SET {$fields} WHERE {$where} LIMIT {$limit}";
	        return $fields ? $this->query($sql) : false;
    	}catch (Exception $e){
    		echo $e->getMessage();
    	}
    }
    
    //----------------------------------------------------------
    
    public function __call($method, $arguments){
    	echo "unfind function: {$method} and arguments";
    }
}