<?php   if ( ! defined('FIT_PATH')) exit('No direct script access allowed');
/**
 * @copyright   Copyright (C) 2009 - 2010 fitphp.com
 * @license     New BSD License
 * @package		FitPHP
 * @subpackage	Database
 * 
 * @author      Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version     $Id: database/mssql.php 1.0 2010-09-18 16:52 hongbin.hsu $
 */
 
// ------------------------------------------------------------------------

require_once('abstract.php');

class Database_Mssql extends Database_Abstract
{
	//----------------------------------------------------------
	/**
	 * 连接数据库
	 *
	 */
    public function connect()
    {
    	try {
    		if (!function_exists('mssql_connect') || !function_exists('mssql_pconnect')) {
    			throw new Exception("Extension do't open Mssql Server");
    		}
    		if(!is_null($this->hostport)){
	            $this->hostname .= ':'.$this->hostport;
	        }
	        if($this->pconnect){
	            $this->conn = mssql_pconnect($this->hostname, $this->username, $this->password);
	        }else{
	            $this->conn = mssql_connect($this->hostname, $this->username, $this->password);
	        }echo 'a';
	        if (!$this->conn) {
	        	throw new Exception("Couldn't connect to SQL Server on $this->hostname");
	        }
	        if (!mssql_select_db($this->database, $this->conn)) {
	        	throw new Exception("Couldn't open database $this->database");
	        }
    	}catch (Exception $e){
    		echo $e->getMessage();
    	}
    }
    
    //----------------------------------------------------------
	/**
	 * 发送一条SQL查询
	 *
	 * @param string $sql
	 * @return resource
	 */
    public function query($sql)
    {
    	try {
    		if ($this->result) { $this->free(); }
    		if (!$this->result = mssql_query($sql, $this->conn)) {
    			throw new Exception('Query Error');
    		}
    	}catch (Exception $e){
    		echo $e->getMessage();
    	}
    }
    
    //----------------------------------------------------------
	/**
	 * 从结果集中取得一行枚举数组
	 *
	 * @param string $sql
	 * @return array
	 */
    public function fetch_row($sql = null)
    {
    	if (!is_null($sql)) {$this->query($sql);}
		return mssql_fetch_array($this->result);
    }
    
    //----------------------------------------------------------
	/**
	 * 从结果集中取得全部关联数组
	 *
	 * @param string $sql
	 * @return array
	 */
    public function fetch_all($sql = null)
    {
    	$data = array();
        if (!is_null($sql)) {$this->query($sql);}
        while( $row = mssql_fetch_array($this->result)){
        	$data[] = $row;
        }
        return $data;
    }
    
    //----------------------------------------------------------
	/**
	 * 执行一条SQL语句
	 *
	 * @param string $sql
	 * @return bool
	 */
    public function execute($sql = null)
    {
        if (!is_null($sql)) {$this->query($sql);}
        return @mssql_rows_affected($this->conn);
    }
    
    //----------------------------------------------------------
	/**
	 * 取得前一次操作所影响的记录行数
	 *
	 * @return int
	 */
     public function affected_rows()
     {
        return @mssql_rows_affected($this->conn);
     }
     
    //----------------------------------------------------------
	/**
	 * 取得结果集中行的数目
	 *
	 * @return int
	 */
     public function num_rows()
     {
         return @mssql_num_rows($this->result);
     }
     
    //----------------------------------------------------------
	/**
	 * 取得上一次Insert操作产生的ID
	 *
	 * @return int
	 */
     public function insert_id()
     {
        $ver = $this->parse_major_version($this->version());
        $sql = (8 <= $ver ? "SELECT SCOPE_IDENTITY() AS last_id" : "SELECT @@IDENTITY AS last_id");
        $query = $this->query($sql);
        $row = $query->row();
        return $row->last_id;
     }
     
    //----------------------------------------------------------
	/**
	 * 释放结果内存
	 *
	 * @return void
	 */
     public function free()
     {
         @mssql_free_result($this->result);
     }
     
    //----------------------------------------------------------
	/**
	 * 关闭数据库连接
	 *
	 * @return void
	 */
     public function close()
     {
         @mssql_close($this->conn);
     }

     //----------------------------------------------------------
     /**
      * 获取数据库版本
      *
      * @return string
      */
     private function version()
     {
        return "SELECT @@VERSION AS ver";
     }
     
     //----------------------------------------------------------
     /**
      * 获取数据库版本等级
      *
      * @param string $version
      * @return int
      */
     private function parse_major_version($version)
     {
        preg_match('/([0-9]+)\.([0-9]+)\.([0-9]+)/', $version, $ver_info);
        return $ver_info[1];    //return the major version b/c that's all we're interested in.
     }
}