<?php   if ( ! defined('FIT_PATH')) exit('No direct script access allowed');
/**
 * @copyright 2009 - 2010 Bincent.com. All Rights Reserved.
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @package		FitPHP
 * @subpackage	Database
 * 
 * @author      Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version     $Id: database/mysql.php 1.0 2010-09-18 16:52 hongbin.hsu $
 */
 
// ------------------------------------------------------------------------

require_once('abstract.php');

class Database_Mysql extends Database_Abstract
{
	//----------------------------------------------------------
	/**
	 * 连接数据库
	 *
	 */
    public function connect()
    {
    	try {
    		if (!function_exists('mysql_connect') || !function_exists('mysql_pconnect')) {
    			throw new Exception("Extension do't open Mysql");
    		}
    		if($this->hostport != ''){ $this->hostname .= ':'.$this->hostport; }
	        if($this->pconnect){
	            $this->conn = @mysql_pconnect($this->hostname, $this->username, $this->password);
	        }else{
	            $this->conn = @mysql_connect($this->hostname, $this->username, $this->password, TRUE);
	        }
	        if (!$this->conn) {
	        	throw new Exception("Couldn't connect to Mysql on $this->hostname");
	        }
	        mysql_select_db($this->database, $this->conn);
	        if(isset($this->charset)){
	            $version = mysql_get_server_info($this->conn);
	            if('4.1' <= $version && !empty($this->charset)){ mysql_query("SET NAMES '{$this->charset}'",$this->conn); }
	            if('5.0.1' < $version){ mysql_query("SET sql_mode='' ",$this->conn); }
	        }
    	}catch (Exception $e){
    		echo $e->getMessage();
    	}
    }
	
    //----------------------------------------------------------
	/**
	 * 发送一条SQL查询
	 *
	 * @param string $sql
	 * @return resource
	 */
    public function query($sql)
    {
        try{
           if ($this->result) { $this->free(); }
           if(!$this->result = mysql_query($sql, $this->conn)){
              throw new Exception('Query Error');
            }
            return $this->result;
        }catch(Exception $e){
            echo $e->getMessage();
        }
    }
    
    //----------------------------------------------------------
	/**
	 * 从结果集中取得一行枚举数组
	 *
	 * @param string $sql
	 * @return array
	 */
    public function fetch_row($sql = null)
    {
    	if (!is_null($sql)) {$this->query($sql);}
		return mysql_fetch_assoc($this->result);
    }
    
    //----------------------------------------------------------
	/**
	 * 从结果集中取得全部关联数组
	 *
	 * @param string $sql
	 * @return array
	 */
    public function fetch_all($sql)
    {
    	$data = array();
        if (!is_null($sql)) {$this->query($sql);}
        while( $row = mysql_fetch_assoc($this->result)){
        	$data[] = $row;
        }
        return $data;
    }

    //----------------------------------------------------------
	/**
	 * 执行一条SQL语句
	 *
	 * @param string $sql
	 * @return bool
	 */
    public function execute($sql = null)
    {
        if (!is_null($sql)) {$this->query($sql);}
        return @mysql_affected_rows($this->conn);
    }
    
    //----------------------------------------------------------
	/**
	 * 取得前一次操作所影响的记录行数
	 *
	 * @return int
	 */
     public function affected_rows()
     {
        return @mysql_affected_rows($this->conn);
     }
     
    //----------------------------------------------------------
	/**
	 * 取得结果集中行的数目
	 *
	 * @return int
	 */
     public function num_rows()
     {
         return @mysql_num_rows($this->result);
     }
     
    //----------------------------------------------------------
	/**
	 * 取得上一次Insert操作产生的ID
	 *
	 * @return int
	 */
     public function insert_id()
     {
        $id = mysql_insert_id($this->conn);
        if(0 >= $id){$this->query("SELECT last_insert_id()");}
        return $id;
     }
     
    //----------------------------------------------------------
	/**
	 * 释放结果内存
	 *
	 * @return void
	 */
     public function free()
     {
         @mysql_free_result($this->result);
     }
     
    //----------------------------------------------------------
	/**
	 * 关闭数据库连接
	 *
	 * @return void
	 */
     public function close()
     {
         @mysql_close($this->conn);
     }
}