<?php   if ( ! defined('FIT_PATH')) exit('No direct script access allowed');
/**
 * @copyright   Copyright (C) 2009 - 2010 fitphp.com
 * @license     New BSD License
 * @package		FitPHP
 * @subpackage	Database
 * 
 * @author      Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version     $Id: database/mysqli.php 1.0 2010-09-18 16:52 hongbin.hsu $
 */
 
// ------------------------------------------------------------------------

require_once('abstract.php');

class Database_Mysqli extends Database_Abstract
{
	//----------------------------------------------------------
	/**
	 * 连接数据库
	 *
	 */
    public function connect()
    {
    	try {
    		if (!class_exists('mysqli')) {
	    		throw new Exception("Extension do't open Mysqli");
	    	}
	        $this->conn = new mysqli($this->hostname,$this->username,$this->password,$this->database,$this->hostport);
	        if (!$this->conn) {
	        	throw new Exception("Couldn't connect to Mysql on $this->hostname");
	        }
	        if(isset($this->charset)){
	            $version = $this->conn->server_version;
	            if('4.1' <= $version && !empty($this->charset)){ $this->conn->query("SET NAMES '{$this->charset}'"); }
	            if('5.0.1' < $version){ $this->conn->query("SET sql_mode='' "); }
	        }
    	}catch (Exception $e){
    		echo $e->getMessage();
    	}
    }
	
	//----------------------------------------------------------
	/**
	 * 发送一条SQL查询
	 *
	 * @param string $sql
	 * @return resource
	 */
    public function query($sql)
    {
        try{
        	if ($this->result) { $this->free(); }
            if(!$this->result = $this->conn->query($sql)){
                throw new Exception(mysqli_error());
            }
        }catch(Exception $e){
            echo $e->getMessage();
        }
    }
    
    //----------------------------------------------------------
	/**
	 * 从结果集中取得一行枚举数组
	 *
	 * @param string $sql
	 * @return array
	 */
    public function fetch_row($sql = null)
    {
    	if (!is_null($sql)) {$this->query($sql);}
		return $this->result->fetch_assoc();
    }
    
	//----------------------------------------------------------
	/**
	 * 从结果集中取得全部关联数组
	 *
	 * @param string $sql
	 * @return array
	 */
    public function fetch_all($sql = null)
    {
    	$data = array();
    	if (!is_null($sql)) {$this->query($sql);}
        while($row = $this->result->fetch_assoc()){
        	$data[] = $row;
        }
        return $data;
    }
    
    //----------------------------------------------------------
	/**
	 * 执行一条SQL语句
	 *
	 * @param string $sql
	 * @return bool
	 */
    public function execute($sql)
    {
        $this->query($sql);
        return @$this->conn->affected_rows;
    }
    
    //----------------------------------------------------------
	/**
	 * 取得前一次操作所影响的记录行数
	 *
	 * @return int
	 */
     public function affected_rows()
     {
        return @$this->conn->affected_rows;
     }
     
    //----------------------------------------------------------
	/**
	 * 取得结果集中行的数目
	 *
	 * @return int
	 */
     public function num_rows()
     {
         return @$this->result->num_rows;
     }
     
    //----------------------------------------------------------
	/**
	 * 取得上一次Insert操作产生的ID
	 *
	 * @return int
	 */
     public function insert_id()
     {
        $id = $this->conn->insert_id;
        if(0 >= $id){$this->conn->query("SELECT last_insert_id()");}
        return $id;
     }
     
    //----------------------------------------------------------
	/**
	 * 释放结果内存
	 *
	 * @return void
	 */
     public function free()
     {
         @$this->result->free_result();
     }
     
    //----------------------------------------------------------
	/**
	 * 关闭数据库连接
	 *
	 * @return void
	 */
     public function close()
     {
         @$this->conn->close();
     }
}