<?php   if ( ! defined('FIT_PATH')) exit('No direct script access allowed');
/**
 * @copyright   Copyright (C) 2009 - 2010 fitphp.com
 * @license     New BSD License
 * @package		FitPHP
 * @subpackage	Database
 * 
 * @author      Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version     $Id: database/odbc.php 1.0 2010-09-18 16:52 hongbin.hsu $
 */
 
// ------------------------------------------------------------------------

require_once('abstract.php');

class Database_Odbc extends Database_Abstract
{
	//----------------------------------------------------------
	/**
	 * 连接数据库
	 *
	 */
	public function connect()
	{
		try {
			if (!function_exists('odbc_connect') || !function_exists('odbc_pconnect')) {
    			throw new Exception("Extension do't open ODBC");
    		}
			if ($this->pconnect) {
				$this->conn = odbc_pconnect($this->dsn, $this->username, $this->password);
			}else{
				$this->conn = odbc_connect($this->dsn, $this->username, $this->password);
			}
			if (!$this->conn) {
	        	throw new Exception("Couldn't connect to Database");
	        }
		}catch (Exception $e){
			echo $e->getMessage();
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 发送一条SQL查询
	 *
	 * @param string $sql
	 * @return resource
	 */
	public function query($sql)
	{
		$this->result = odbc_exec($this->conn, $sql);
	}
	
	//----------------------------------------------------------
	/**
	 * 从结果集中取得一行枚举数组
	 *
	 * @param string $sql
	 * @return array
	 */
	public function fetch_row($sql = null)
	{
		if (!is_null($sql)) {$this->query($sql);}
		return odbc_fetch_array($this->result);
	}
	
	//----------------------------------------------------------
	/**
	 * 从结果集中取得全部关联数组
	 *
	 * @param string $sql
	 * @return array
	 */
	public function fetch_all($sql = null)
	{
		$data = array();
		if (!is_null($sql)) {$this->query($sql);}
		while ($row = odbc_fetch_array($this->result)){
			$data[] = $row;
		}
		return $data;
	}
	
	//----------------------------------------------------------
	/**
	 * 执行一条SQL语句
	 *
	 * @param string $sql
	 * @return bool
	 */
	public function execute($sql = null)
	{
		if (!is_null($sql)) {$this->query($sql);}
		return $this->result;
	}
	
	//----------------------------------------------------------
	/**
	 * 取得前一次操作所影响的记录行数
	 *
	 * @return int
	 */
	public function affected_rows()
	{
		
	}
	
	//----------------------------------------------------------
	/**
	 * 取得结果集中行的数目
	 *
	 * @return int
	 */
	public function num_rows()
	{
		return odbc_num_rows($this->result);
	}
	
	//----------------------------------------------------------
	/**
	 * 取得上一次Insert操作产生的ID
	 *
	 * @return int
	 */
	public function insert_id()
	{
		
	}
	
	//----------------------------------------------------------
	/**
	 * 释放结果内存
	 *
	 * @return void
	 */
	public function free()
	{
		odbc_free_result($this->result);
	}
	
	//----------------------------------------------------------
	/**
	 * 关闭数据库连接
	 *
	 * @return void
	 */
	public function close()
	{
		odbc_close($this->conn);
	}
}