<?php   if ( ! defined('FIT_PATH')) exit('No direct script access allowed');
/**
 * @copyright   Copyright (C) 2009 - 2010 fitphp.com
 * @license     New BSD License
 * @package		FitPHP
 * @subpackage	Database
 * 
 * @author      Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version     $Id: database/oracle.php 1.0 2010-09-18 16:52 hongbin.hsu $
 */
 
// ------------------------------------------------------------------------

require_once('abstract.php');

class Database_Oracle extends Database_Abstract
{
	//----------------------------------------------------------
	/**
	 * 连接数据库
	 *
	 */
	public function connect()
	{
		try {
			if (!function_exists('oci_connect') || !function_exists('oci_pconnect')) {
    			throw new Exception("Extension do't open Oracle");
    		}
			if($this->pconnect){
	            $this->conn = oci_pconnect($this->username,$this->password,$this->database,$this->charset);
	        }else{
	            $this->conn = oci_connect($this->username,$this->password,$this->database,$this->charset);
	        }
	        if (!$this->conn) {
	        	throw new Exception("Couldn't connect to Oracle on $this->hostname");
	        }
		}catch (Exception $e){
			echo $e->getMessage();
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 发送一条SQL查询
	 *
	 * @param string $sql
	 * @return resource
	 */
	public function query($sql)
	{
		$this->result = oci_parse($this->conn,$sql);
	}
	
	//----------------------------------------------------------
	/**
	 * 从结果集中取得一行枚举数组
	 *
	 * @param string $sql
	 * @return array
	 */
	public function fetch_row($sql = null)
	{
		if (!is_null($sql)) {$this->query($sql);}
		return oci_fetch_assoc($this->result);
	}
	
	//----------------------------------------------------------
	/**
	 * 从结果集中取得全部关联数组
	 *
	 * @param string $sql
	 * @return array
	 */
	public function fetch_all($sql = null)
	{
		$data = array();
        if (!is_null($sql)) {$this->query($sql);}
        while($row = oci_fetch_assoc($this->result)){
        	$data[] = $row;
        }
        return $data;
	}
	
	//----------------------------------------------------------
	/**
	 * 执行一条SQL语句
	 *
	 * @param string $sql
	 * @return bool
	 */
	public function execute($sql = null)
	{
		if (!is_null($sql)) {$this->query($sql);}
		return oci_execute($this->result);
	}
	
	//----------------------------------------------------------
	/**
	 * 取得结果集中行的数目
	 *
	 * @return int
	 */
	public function num_rows()
	{
		return @oci_num_rows($this->result);
	}
	
	//----------------------------------------------------------
	/**
	 * 取得上一次Insert操作产生的ID
	 *
	 * @return int
	 */
     public function insert_id()
     {
     	
     }
     
	//----------------------------------------------------------
	/**
	 * 释放结果内存
	 *
	 * @return void
	 */
	public function free()
	{
		@oci_cancel($this->result);
	}
	
	//----------------------------------------------------------
	/**
	 * 关闭数据库连接
	 *
	 * @return void
	 */
	public function close()
	{
		@oci_close($this->conn);
	}
}