<?php   if ( ! defined('FIT_PATH')) exit('No direct script access allowed');
/**
 * @copyright 2009 - 2010 Bincent.com. All Rights Reserved.
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @package		FitPHP
 * @subpackage	Database
 * 
 * @author      Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version     $Id: database/pdo.php 1.0 2010-09-18 16:52 hongbin.hsu $
 */
 
// ------------------------------------------------------------------------

require_once('abstract.php');

class Database_Pdo extends Database_Abstract
{
	//----------------------------------------------------------
	/**
	 * 连接数据库
	 *
	 */
	public function connect()
	{
		try {
			$this->conn = new PDO($this->dsn, $this->username, $this->password);
			$version = $this->conn->getAttribute(PDO::ATTR_SERVER_VERSION);
			if ($version > '4.1'  && !empty($this->charset)){
				$this->conn->exec("SET NAMES '{$this->charset}'");
			}
			if ($version > '5.0.1'){
				$this->conn->exec("SET @@sql_mode = ''");
			}
		}catch (PDOException $e){
			echo $e->getMessage();
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 发送一条SQL查询
	 *
	 * @param string $sql
	 * @return resource
	 */
    public function query($sql)
    {
    	$this->result = $this->conn->query($sql);
        return $this->result;
    }
	
    //----------------------------------------------------------
	/**
	 * 从结果集中取得一行枚举数组
	 *
	 * @param string $sql
	 * @return array
	 */
	public function fetch_row($sql = null)
	{
		if (!is_null($sql)) {$this->query($sql);}
		$this->result = setFetchMode(PDO::FETCH_ASSOC);
		$data = $this->result->fetch();
        return $data;
	}
	
	//----------------------------------------------------------
	/**
	 * 从结果集中取得全部关联数组
	 *
	 * @param string $sql
	 * @return array
	 */
    public function fetch_all($sql = null)
    {
    	if (!is_null($sql)) {$this->query($sql);}
    	$this->result = setFetchMode(PDO::FETCH_ASSOC);
    	$this->result = $this->result->fetchAll();
        return $this->result;
    }

    //----------------------------------------------------------
	/**
	 * 执行一条SQL语句
	 *
	 * @param string $sql
	 * @return bool
	 */
    public function execute($sql = null)
    {
    	$this->result = $this->conn->exec($sql);
        return $this->result;
    }
    
    //----------------------------------------------------------
	/**
	 * 取得前一次操作所影响的记录行数
	 *
	 * @return int
	 */
     public function affected_rows()
     {
     	return $this->result;
     }
     
    //----------------------------------------------------------
	/**
	 * 取得结果集中行的数目
	 *
	 * @return int
	 */
     public function num_rows()
     {
     	return count($this->result);
     }
     
    //----------------------------------------------------------
	/**
	 * 取得上一次Insert操作产生的ID
	 *
	 * @return int
	 */
     public function insert_id()
     {
     	return $this->conn->lastInsertId();
     }
     
    //----------------------------------------------------------
	/**
	 * 释放结果内存
	 *
	 * @return void
	 */
     public function free()
     {
     	$this->result = null;
     }
     
    //----------------------------------------------------------
	/**
	 * 关闭数据库连接
	 *
	 * @return void
	 */
     public function close()
     {
     	$this->conn = null;
     }
}