<?php
/**
 * @copyright 2009 - 2010 Bincent.com. All Rights Reserved.
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @package FitPHP
 * 
 * @author Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version $Id: fitphp.php 1.0 2010-09-18 16:52 hongbin.hsu $
 */
// FitPHP Version
define('FIT_VERSION',	'2.0');

/*检查定义项目路径,以确定目录*/
if (!defined('APP_PATH')) exit('ERROR：Must define APP_PATH!');
/*定义框架绝对路径,以及防止被*/
if (!defined('FIT_PATH')) { define('FIT_PATH', dirname(__FILE__));}

require_once('core/base.php');
require_once('core/application.php');
require_once('core/controller.php');
require_once('core/model.php');

unset($GLOBALS, $_ENV, $HTTP_GET_VARS, $HTTP_POST_VARS,
$HTTP_COOKIE_VARS, $HTTP_SERVER_VARS, $HTTP_ENV_VARS);
$_GET 		= addslashe($_GET, 1, true);
$_POST 		= addslashe($_POST, 1, true);
$_COOKIE 	= addslashe($_COOKIE, 1, true);
$_SERVER 	= addslashe($_SERVER);
$_FILES 	= addslashe($_FILES);
$_REQUEST 	= addslashe($_REQUEST, 1, true);

//----------------------------------------------------------
/**
 * 自动加载核心模块
 *
 * @param string $classname 对象名称
 */
function __autoload($classname){
    $classname = strtolower($classname);
    $classname = str_replace('_', DIRECTORY_SEPARATOR, $classname);
    require_once(FIT_PATH.DIRECTORY_SEPARATOR.$classname.'.php');
}

//----------------------------------------------------------
/**
 * 数据过滤
 *
 * @param string $str
 * @param int $force
 * @param bool $strip
 * @access public
 * @return string
 */ 
function addslashe($str, $force = 0, $strip = false) {
	if (!get_magic_quotes_gpc() || $force) {
		if (is_array($str)) {
        	foreach ($str as $k => $v){
        		$str[$k] = addslashe($v, $force);
        	}
   		}else{
        	$str = addslashes($strip ? stripslashes($str) : $str);
    	}
	}
    return $str;
}