<?php   if ( ! defined('FIT_PATH')) exit('No direct script access allowed');
/**
 * @copyright 2009 - 2010 Bincent.com. All Rights Reserved.
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @package	FitPHP
 * @subpackage library
 * 
 * @author Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version $Id: library/apc.php 1.0 2009-07-18 13:34 hongbin.hsu $
 */
 
// ------------------------------------------------------------------------

class Library_Apc
{
	public $lift_time = 900;			//过期时间
	
	//----------------------------------------------------------
	/**
	 * 构造函数
	 *
	 * @param 默认的缓存策略 $policy
	 */
	public function __construct(array $policy = null)
	{
		if (isset($policy['lift_time'])) {
			$this->lift_time = intval($policy['lift_time']);
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 写入缓存
	 *
	 * @param string $key
	 * @param mixed $data
	 * @param int $lift_time
	 */
	public function set($key, $data, $lift_time = null)
	{
		$lift_time = isset($lift_time) ? $lift_time : $this->lift_time;
		return apc_store($key, $data, $lift_time);
	}
	
	//----------------------------------------------------------
	/**
	 * 检查是否存在该缓存
	 *
	 * @param string $key
	 */
	public function is_set($key)
	{
		return (apc_fetch($key) === false ? false : true);
	}
	
	//----------------------------------------------------------
	/**
	 * 读取缓存，读取失败或缓存失效返回false
	 *
	 */
	public function get($key)
	{
		return apc_fetch($key);
	}
	
	//----------------------------------------------------------
	/**
	 * 移除指定缓存
	 * 
	 * @param string $id
     * @return boolean
	 */
	public function delete($key)
	{
		return apc_delete($key);
	}
	
	//----------------------------------------------------------
	/**
	 * 清空所有缓存
	 *
	 */
	public function clear()
	{
		return apc_clear_cache();
	}
}