<?php   if ( ! defined('FIT_PATH')) exit('No direct script access allowed');
/**
 * @copyright 2009 - 2010 Bincent.com. All Rights Reserved.
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @package FitPHP
 * @subpackage library
 *
 * @author Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version $Id: library/cache.php 1.0 2010-04-18 23:02 hongbin.hsu $
 */
 
// ------------------------------------------------------------------------

class Library_Cache
{
	public $lift_time		= 900;		//过期时间
	protected $cache_dir	= 'cache';	//缓存存放目录
	protected $suffix		= '.html';	//缓存文件后缀
	
	//----------------------------------------------------------
	/**
	 * 构造函数,检查是否存在该文件夹，无则创建
	 *
	 * @param 默认的缓存策略 $policy
	 */
	public function __construct(array $policy = null)
	{
		if (!is_null($policy)) {
    		foreach($policy as $key => $value){
				$this->$key = $value;
			}
    	}
		$this->_set_cache_dir();
	}
	
	//----------------------------------------------------------
	/**
	 * 写入缓存
	 *
	 * @param string $key
	 * @param mixed $data
	 * @param int $lift_time
	 */
	public function set($key, $data, $lift_time = null)
	{
		$lift_time	= isset($lift_time) ? $lift_time : $this->lift_time;
		$key		= $this->cache_dir.'/'.md5($key).$this->suffix;
		$data		= serialize($data);
		@file_put_contents($key,$data);
		@chmod($key,0755);
		@touch($key, time()+$lift_time);
	}
	
	//----------------------------------------------------------
	/**
	 * 判断缓存文件是否存在
	 *
	 * @param string $key
	 * @return bool
	 */
	public function is_set($key)
	{
		if (file_exists($this->cache_dir.'/'.md5($key).$this->suffix)) {
			return true;
		}else{
			return false;
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 读取缓存，读取失败或缓存失效返回false
	 *
	 */
	public function get($key)
	{
		$key = $this->cache_dir.'/'.md5($key).$this->suffix;
		if (@filemtime($key) >= time()) {
			return unserialize(file_get_contents($key));
		}else{
			@unlink($key);
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 移除指定缓存
	 * 
	 * @param string $id
     * @return boolean
	 */
	public function delete($key)
	{
		$file = $this->cache_dir.'/'.md5($key).$this->suffix;
		return @unlink($file);
	}
	
	//----------------------------------------------------------
	/**
	 * 刷新过期缓存使之失效
	 *
	 */
	public function flush()
	{
		$files = scandir($this->cache_dir);
		foreach ($files as $file) {
			if ((time()- filemtime($file) < $this->lift_time)) {
				@unlink($file);
			}
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 请空所有缓存文件
	 *
	 */
	public function clear()
	{
		$files = scandir($this->cache_dir);
		foreach ($files as $file){
			@unlink($file);
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 设置缓存目录
	 *
	 */
	protected function _set_cache_dir() {
		try {
			$this->cache_dir = rtrim(str_replace('\\', '/', trim($this->cache_dir)), '/'); 
			$this->cache_dir = 'data/'.$this->cache_dir; 
			if (!is_dir($this->cache_dir)) {@mkdir($this->cache_dir,0755);}
			@chmod($this->cache_dir, 0755, true);
			if(!is_writable($this->cache_dir)) {
				throw new Exception('Cache Folder '.$this->cache_dir.' Not writable.');
			}
		}catch (Exception $error) {
			echo $error->getMessage();
		}
	}
}