<?php   if ( ! defined('FIT_PATH')) exit('No direct script access allowed');
/**
 * @copyright 2009 - 2010 Bincent.com. All Rights Reserved.
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @package	FitPHP
 * @subpackage library
 * 
 * @author Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version $Id: library/captcha.php 1.0 2010-09-18 16:52 hongbin.hsu $
 */
 
// ------------------------------------------------------------------------

class Library_Captcha
{
	private $width = 150;
	private $height = 30;
	private $length = 4;
	private $disturb = null;
	private $check_image = null;
	private $check_code = null;

	//----------------------------------------------------------
	/**
	 * 验证码构造方法
	 *
	 * @param int $width
	 * @param int $height
	 * @param int $length
	 */
	public function __construct($width = 80, $height = 20, $length = 4){
			$this->width = $width;
			$this->height = $height;
			$this->length = $length;
	}

	//----------------------------------------------------------
	/**
	 * 设置图像宽度
	 *
	 * @param int $width
	 */
	public function set_width($width){
		$this->width = $width;
	}

	//----------------------------------------------------------
	/**
	 * 设置图像高度
	 *
	 * @param int $height
	 */
	public function set_height($height){
		$this->height = $height;
	}

	//----------------------------------------------------------
	/**
	 * 设置验证码位数
	 *
	 * @param int $length
	 */
	public function set_length($length){
		$this->length = $length;
	}

	//----------------------------------------------------------
	/**
	 * 输出验证码
	 *
	 */
	public function display(){
		$this->out_file_header();
		$this ->create_check_code();
		$this ->create_image();
		$this ->set_disturb();
		$this ->write_check_code_to_image();
		imagepng($this->check_image);
		imagedestroy($this->check_image);
	}

	//----------------------------------------------------------
	/**
	 * 输出图像类型
	 *
	 */
	private function out_file_header()
	{
		header ("Content-type: image/png");
	}

	//----------------------------------------------------------
	/**
	 * 创建验证码
	 *
	 * @return string
	 */
	private function create_check_code()
	{
	   $this->check_code = strtoupper(substr(md5(rand()),0,$this->length));
	   return $this->check_code;
	}

	//----------------------------------------------------------
	/**
	 * 产生验证码图片
	 *
	 * @return string
	 */
	private function create_image()
	{
	   $this->check_image = @imagecreate ($this->width,$this->height);
	   imagecolorallocate ($this->check_image, 200, 200, 200);
	   return $this->check_image;
	}

	//----------------------------------------------------------
	/**
	 * 设置干扰像素
	 *
	 */
	private function set_disturb(){
		for ($i=0;$i<=128;$i++){
	    	$this->disturb = imagecolorallocate($this->check_image, rand(0,255), rand(0,255), rand(0,255));
	    	imagesetpixel($this->check_image,rand(2,128),rand(2,38),$this->disturb);
		}
	}

	//----------------------------------------------------------
	/**
	 * 在验证码图片上逐个画上验证码
	 *
	 */
	private function write_check_code_to_image()
	{
	   for ($i=0;$i<=$this->length;$i++){
	    $bg_color = imagecolorallocate ($this->check_image, rand(0,255), rand(0,128), rand(0,255));
	    $x = floor($this->width/$this->length)*$i;
	    $y = rand(0,$this->height-15);
	    imagechar ($this->check_image, 5, $x, $y, $this->check_code[$i], $bg_color);
	   }
	}
}