<?php   if ( ! defined('FIT_PATH')) exit('No direct script access allowed');
/**
 * @copyright 2009 - 2010 Bincent.com. All Rights Reserved.
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @package FitPHP
 * @subpackage library
 * 
 * @author Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version $Id: library/ftp.php 1.0 2010-09-18 16:52 hongbin.hsu $
 */
 
// ------------------------------------------------------------------------

class Library_Ftp
{
	protected $conn;
	protected $login = false;
	
	//----------------------------------------------------------
	/**
	 * 连接FTP服务器
	 *
	 * @param unknown_type $host
	 * @param unknown_type $port
	 */
	public function connect($host, $port = 21) {
		$this->conn = ftp_connect($host, $port);
	}
	
	//----------------------------------------------------------
	/**
	 * 断开FTP服务器
	 *
	 */
	public function quit() {
		ftp_quit($this->conn);
	}
	
	//----------------------------------------------------------
	/**
	 * 查看服务器的操作系统类型
	 *
	 * @return string
	 */
	public function systype() {
		return ftp_systype($this->conn);
	}
	
	//----------------------------------------------------------
	/**
	 * 登陆FTP服务器
	 *
	 * @param string $username	FTP用户名
	 * @param string $password	FTP密码
	 */
	public function login($username, $password) {
		$this->login = ftp_login($this->conn, $username, $password);
	}
	
	//----------------------------------------------------------
	/**
	 * 获取文件列表
	 *
	 * @param string $directory	要读取的目录
	 * @return array
	 */
	public function nlist($directory) {
		if ($this->check()) {
			return ftp_nlist($this->conn, $directory);
		}else{
			return array();
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 上传文件
	 *
	 * @param string $remote_file 上传后的远程文件名
	 * @param string $local_file 本地文件名
	 * @param string $mode	上传模式FTP_ASCII(文本模式)
	 * 或FTP_BINARY(二进制模式)
	 * @return bool
	 */
	public function put($remote_file, $local_file, $mode = FTP_BINARY) {
		if ($this->check()) {
			return ftp_put($this->conn, $remote_file, $local_file, $mode);
		}else{
			return false;
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 下载文件
	 *
	 * @param string $local_file 下载后的本地文件名
	 * @param string $remote_file 远程服务器的文件名
	 * @param string $mode	上传模式FTP_ASCII(文本模式)
	 * 或FTP_BINARY(二进制模式)
	 * @return bool
	 */
	public function get($local_file, $remote_file, $mode = FTP_BINARY) {
		if ($this->check()) {
			return ftp_get($this->conn, $remote_file, $local_file, $mode);
		}else{
			return false;
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 删除文件
	 *
	 * @param string $remote_file 被删除的远程服务器的文件名
	 * @return bool
	 */
	public function delete($remote_file) {
		if ($this->check()) {
			return ftp_delete($this->conn, $remote_file);
		}else{
			return false;
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 新建目录
	 *
	 * @param string $dir 目录名称
	 * @return bool
	 */
	public function mkdir($dir) {
		if ($this->check()) {
			return ftp_mkdir($this->conn, $dir);
		}else{
			return false;
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 移除目录
	 *
	 * @param string $dir 目录名称
	 * @return bool
	 */
	public function rmdir($dir) {
		if ($this->check()) {
			return ftp_rmdir($this->conn, $dir);
		}else{
			return false;
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 检查与FTP服务器连接状态
	 *
	 * @return bool
	 */
	protected function check() {
		if (!$this->conn) {
			echo "FTP服务器连接失败";
			return false;
		}else{
			if (!$this->login) {
				echo "用户名或密码错误";
				return false;
			}else{
				return true;
			}
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 析构函数,自动断开连接
	 *
	 */
	public function __destruct() {
		$this->quit();
	}
}