<?php   if ( ! defined('FIT_PATH')) exit('No direct script access allowed');
/**
 * @copyright 2009 - 2010 Bincent.com. All Rights Reserved.
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @package	FitPHP
 * @subpackage library
 * 
 * @author Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version $Id: library/log.php 1.0 2010-12-03 23:03 hongbin.hsu $
 */
 
// ------------------------------------------------------------------------

class Library_Log
{
	private $enabled = true;
	private $levels	= array('error'=>'1', 'debug'=>'2', 'info'=>'3', 'all'=>'4');
	private $config = array('log_path', 'log_file_ext', 'log_date_format', 'log_threshold');
	
	public $log_threshold = 0;
	public $log_path = 'log';
	public $log_file_ext = '.txt';
	public $log_date_format = 'Y-m-d H:i:s';
	
	//----------------------------------------------------------
	/**
	 * 日志构造
	 *
	 * @param array $config
	 */
	public function __construct($config){
		
		foreach ($config as $key => $value){
			if (!empty($value) && in_array($key, $this->config)) {
				$this->$key = $value;
			}
		}
		
		$log_path = APP_PATH.DIRECTORY_SEPARATOR;
		$log_path .= trim($this->log_path, '/').DIRECTORY_SEPARATOR;
		
		if (is_dir($log_path) && is_really_writable($log_path)){
			$this->log_path = $log_path;
		}else{
			$this->enabled = false;
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 记录日志
	 *
	 * @param string $msg
	 * @param string $level
	 * @return bool
	 */
	public function write_log($msg, $level = 'error'){
		if (!$this->enabled) {
			return false;
		}
		
		if (!isset($this->levels[$level]) || ($this->levels[$level] > $this->log_threshold)){
			return false;
		}
		
		$level = strtolower($level);
		$filepath = $this->log_path.'log-'.date('Y-m-d').$this->log_file_ext;
		
		if (!file_exists($filepath)){
			return false;
		}
		
		if (!$fp = @fopen($filepath, FOPEN_WRITE_CREATE)){
			return false;
		}
		
		$message = $level.' '.(($level == 'info') ? ' -' : '-').' '.date($this->log_date_format). ' --> '.$msg."\n";
		
		flock($fp, LOCK_EX);	
		fwrite($fp, $message);
		flock($fp, LOCK_UN);
		fclose($fp);
	
		@chmod($filepath, FILE_WRITE_MODE); 		
		return true;
	}
}