<?php   if ( ! defined('FIT_PATH')) exit('No direct script access allowed');
/**
 * @copyright 2009 - 2010 Bincent.com. All Rights Reserved.
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @package	FitPHP
 * @subpackage library
 * 
 * @author Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version $Id: library/memcache.php 1.0 2009-07-18 13:34 hongbin.hsu $
 */
 
// ------------------------------------------------------------------------

class Library_Memcache
{
	public $lift_time = 900;			//过期时间
	protected $conn = null;				//memcached连接句柄
	protected $default_server = array(
		'host' => '127.0.0.1',			//缓存服务器地址或主机名
		'port' => '11211'				//缓存服务器端口
	);	
	protected $servers = array();		//缓存服务器配置,参看$default_server允许多个缓存服务器
	protected $compressed = false;		//是否压缩缓存数据
	protected $pconnect = false;		//是否使用持久连接
	
	//----------------------------------------------------------
	/**
	 * 构造函数
	 *
	 * @param  $policy	默认的缓存策略
	 */
	public function __construct(array $policy = null)
	{
		try {
			if (!extension_loaded('memcache')){
	            throw new Exception('The memcache extension must be loaded before use!');
	        }
	        
	        if (!is_null($policy)) {
	    		foreach($policy as $key => $value){
					$this->$key = $value;
				}
	    	}
	    	
	    	if (empty($this->servers)) {
	    		$this->servers = $this->default_server;
	    	}
	    	
	    	$this->conn = new Memcache();
	    	foreach ($this->servers as $server){
	            $result = $this->conn->addServer($server['host'], $server['port'], $this->pconnect);
	            if (!$result){
	                throw new Exception(sprintf('Connect memcached server [%s:%s] failed!', $server['host'], $server['port']));
	            }
	        }
		}catch (Exception $error){
			echo $error->getMessage();
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 增加缓存服务器
	 *
	 * @param string $host	服务器名称
	 * @param string $port	服务器端口
	 * @param int $weight	服务器权重
	 */
	public function add_server($host, $port = 11211, $weight = 10)
	{
		$this->conn->addServer($host, $port, true, $weight); 
	}
	
	//----------------------------------------------------------
	/**
	 * 写入缓存
	 *
	 * @param string $key
	 * @param mixed $data
	 * @param int $lift_time
	 */
	public function set($key, $data, $lift_time = null)
	{
        $life_time = isset($life_time) ? $life_time : $this->life_time;
        $this->conn->set($id, $data, $this->compressed ? MEMCACHE_COMPRESSED : 0, $life_time);
	}
	
	//----------------------------------------------------------
	/**
	 * 检查是否存在该缓存
	 *
	 * @param string $key
	 */
	public function is_set($key)
	{
		return ($this->get($key) === false ? false : true);
	}
	
	//----------------------------------------------------------
	/**
	 * 读取缓存，读取失败或缓存失效返回false
	 *
	 */
	public function get($key)
	{
		return $this->conn->get($key);
	}
	
	//----------------------------------------------------------
	/**
	 * 移除指定缓存
	 * 
	 * @param string $id
     * @return boolean
	 */
	public function delete($key)
	{
		return $this->conn->delete($key);
	}
	
	//----------------------------------------------------------
	/**
	 * 请空所有缓存文件
	 *
	 */
	public function flush()
	{
		return $this->conn->flush();
	}
}