<?php   if ( ! defined('FIT_PATH')) exit('No direct script access allowed');
/**
 * @copyright 2009 - 2010 Bincent.com. All Rights Reserved.
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @package	FitPHP
 * @subpackage library
 * 
 * @author Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version $Id: library/page.php 1.0 2010-09-18 16:52 hongbin.hsu $
 */
 
// ------------------------------------------------------------------------

class Library_Page
{
	private $page = null;	            //当前页
	private $start;	                    //开始页
	private $end;	                    //结束页
	protected $total;	                //总的记录数
	protected $roll = 10;	            //分栏数
	protected $rows = 10;	            //每页显示记录数
	protected $url = '#';		        //分页跳转的参数
	protected $segment = 'page';	    //分页方法 URI 的哪个部分包含页数
	protected $first_link = 'First';    //自定义起始链接名字
	protected $prev_link = '&lt;';	    //自定义上一页链接名字
	protected $next_link = '&gt;';	    //自定义下一页链接名字
	protected $last_link = 'Last';	    //自定义结束链接名字
	
	//----------------------------------------------------------
	/**
	 * 构造函数
	 *
	 * @param array $params
	 */
	public function __construct($params = array()){
		if (count($params) > 0) {
			$this->init($params);
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 配置分页类基本参数 
	 *
	 * @param array $params
	 */
	public function init($params = array()){
		foreach ($params as $key => $value){
			$key = strtolower($key);
			$this->$key = $value;
		}
	}
	
	//----------------------------------------------------------
	/**
	 * 分页显示输出
	 *
	 */
	public function display(){
		$this->total = ceil($this->total/$this->rows);
		if (!empty($_GET[$this->segment])) {
			$this->page = $_GET[$this->segment];	//取得当前页数
		}

		$this->roll = ($this->roll > 1) ? $this->roll : 1;
		$this->page = is_null($this->page) ? 1 : $this->page;
		
		if($this->page > $this->total){
			$this->page = $this->total;		//屏蔽人为的输入超过页数的值
		}
		if($this->page < 1){
			$this->page = 1;				//屏蔽人为的输入小于最小页数的值
		}
		$this->start = ($this->page > 3) ? ($this->page - 2) : 1; //避免从负数开始
		$this->end = $this->start + $this->roll - 1;
		
		if($this->end >= $this->total){		//判断超过最大页数
			$this->start = $this->total - $this->roll;
			$this->end = $this->total;
		}
		if($this->total < $this->roll){		//总页数小于显示页数
			$this->start = 1;
			$this->end = $this->total;
		}

		$this->url = rtrim($this->url, '/') .'/';
		$str = '';
		if ($this->page > 1) {
			$str .= '<a href="'.$this->url.'1">'.$this->first_link.'</a>';
			$str .=  '<a href="'.$this->url.($this->page-1).'">'.$this->prev_link.'</a>';
		}
		for($i = $this->start; $i <= $this->end; $i++) {
			if ($i == $this->page) {
				$str .=  '<strong>'.$i.'</strong>';
			}else{
				$str .=  '<a href="'.$this->url.$i.'">'.$i.'</a>';
			}
		}
		if ($this->page < $this->total) {
			$str .=  '<a href="'.$this->url.($this->page+1).'">'.$this->next_link.'</a>';
			$str .=  '<a href="'.$this->url.$this->total.'">'.$this->last_link.'</a>';
		}
		return $str;
	}
}