<?php   if ( ! defined('FIT_PATH')) exit('No direct script access allowed');
/**
 * @copyright 2009 - 2010 Bincent.com. All Rights Reserved.
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @package FitPHP
 * @subpackage library
 * 
 * @author Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version $Id: library/encrypt.php 1.0 2010-09-18 16:52 hongbin.hsu $
 */
 
// ------------------------------------------------------------------------

class Socket
{
	//----------------------------------------------------------
	/**
	 * 远程提交数据
	 *
	 * @param string $path
	 * @param string $query
	 * @param string $method
	 * @return string
	 */
	public function visit_page($path, $query, $method = 'POST') {
		/*获取主机地址*/
		$array = explode('/', $path);
		if (strtolower($array[0]) != "http:") { return false; }
		
		$host = $array[2];
		/*构造页面访问请求*/
		$post = "{$method} {$path} HTTP:/1.1\r\n";
		$post.= "Host: {$host}\r\n";
		$post.= "Content-type: application/x-www-form-urlencoded\r\n";
		$post.= "User-Agent: Mozilla 4.0\r\n";
		$post.= "Content-length: ".strlen($query)."\r\n";
		$post.= "Connection: close\r\n\r\n";
		$post.= "{$query}";
		
		/*使用fsockopen连接页面并将请求信息提交*/
		$port = explode(':', $host);
		$port = empty($port[1]) ? 80 : intval($port[1]);
		$fp = fsockopen($host, $port);
		fwrite($fp, $post);
		do {
			$row = fgets($fp);
			$content.= $row;
		}while ($row);
		/*关闭服务器链接并返回页面的全部数据*/
		fclose($fp);
		
		return $content;
	}
}