<?php   if ( ! defined('FIT_PATH')) exit('No direct script access allowed');
/**
 * @copyright 2009 - 2010 Bincent.com. All Rights Reserved.
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @package FitPHP
 * @subpackage library
 * 
 * @author Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version $Id: library/upload.php 1.0 2010-09-18 16:52 hongbin.hsu $
 */
 
// ------------------------------------------------------------------------

class Library_Upload
{
	private $filename;
	private $savename;
	private $errno = 0;
	private $maxsize = 210000000;
	private $savepath;
	public  $format = '';
	public 	$overwrite = false;
	public 	$ext;
	
	//----------------------------------------------------------
	
	public function __construct() {
		
	}
	
	//----------------------------------------------------------
	
	public function set_save_path($path) {
		$this->savepath = substr($path, -1) == "/" ? $path : $path.'/';
	}
	
	//----------------------------------------------------------
	
	public function set_over_write($bool) {
		$this->overwrite = $bool;
	}
	
	//----------------------------------------------------------
	
	public function set_max_size($maxsiz) {
		$this->maxsize = !$maxsiz ? $this->maxsize : $maxsiz;
	}
	
	//----------------------------------------------------------
	
	public function set_format($format) {
		$this->format = $format;
	}
	
	//----------------------------------------------------------
	
	public function set_save_name($savename) {
		if ($savename == '') {
			srand((double) microtime() * 1000000);
			$rnd = rand(100,999);
			$name = date('U') + $rnd;
			$name = $name.'.'.$this->ext;
		}else{
			$name = $favename;
		}
		$this->savename = $name;
	}
	
	//----------------------------------------------------------
	
	public function upload_file($form, $file = '') {
		if (!isset($_FILES[$form])) {
			echo '指定的文件域名不存在';
		}else{
			$filear = $_FILES[$form];
		}
		
		if (!is_writable($this->savepath)) {
			echo '指定的路径不可写';
		}
		
		if (is_array($filear['name'])) {
			for ($i = 0; $i < count($filear['name']); $i++){
				$temp['name'] = $filear['name'][$i];
				$temp['tmp_name'] = $filear['tmp_name'][$i];
				$temp['size'] = $filear['size'][$i];
				$temp['error'] = $filear['error'][$i];
				
				$this->get_file_ext($temp['name']);
				$this->set_save_name();
				$this->copy_file($temp);
			}
		}else{
			$this->get_file_ext($filear['name']);
			$this->set_save_path($file);
			$this->copy_file($filear);
		}
		return true;
	}
	
	//----------------------------------------------------------
	
	private function copy_file($filear) {
		if ($filear['size'] > $this->maxsize) {
			echo "上传文件{$filear['name']}大小超出系统限定值[{$this->maxsize}字节],不能上传";
		}
		
		if (!$this->overwrite && file_exists($this->savename)) {
			echo "{$this->savename}文件名已经存在";
		}
		
		if ($this->format != '' && !in_array(strtolower($this->ext),explode(',',strtolower($this->format)))) {
			echo "{$this->ext},文件格式不允许上传";
		}
		
		if (!copy($filear['tmp_name'],$this->savepath.$this->savename)) {
			$errors = array(
				0=>'文件上传成功',
				1=>'上传的文件超过了php.ini中upload_max_filesize选项限制的值',
				2=>'上传文件的大小超过了HTML表单中MAX_FILE_SIZE选项限制的值',
				3=>'文件只有部份被上传',
				4=>'没有文件被上传'
			);
			echo $errors[$filear['error']];
		}else{
			@unlink($filear['tmp_name']);
		}
	}
	
	//----------------------------------------------------------
	
	private function get_file_ext($filename) {
		if ($filename == '') {
			return ;
		}else{
			$ext = explode('.',$filename);
			$this->ext = $ext[1];
		}
	}
}