<?php   if ( ! defined('FIT_PATH')) exit('No direct script access allowed');
/**
 * @copyright 2009 - 2010 Bincent.com. All Rights Reserved.
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @package	FitPHP
 * @subpackage library
 * 
 * @author Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version $Id: library/validate.php 1.0 2010-09-18 16:52 hongbin.hsu $
 */
 
// ------------------------------------------------------------------------

class Validate
{
	protected $rules = array();
	
	//----------------------------------------------------------
	public function set_rules($field, $func, $args = array()){
		$this->rules[] = array(
			'field' => $field,
			'func' => strtolower($func),
			'args' => $args,
		);
	}
	
	//----------------------------------------------------------
	public function run($config){
		try {
			foreach ($this->rules as $item){
				$str = $item['str'];
				$func = $item['func'];
				$args = $item['args'];
				if (!$this->$item['func']($str, $args)) {
					throw new Exception("{$item['str']} is error!");
				}
			}
		}catch (Exception $e){
			echo $e->getMessage();
		}
	}
	
	//----------------------------------------------------------
	public function credit(){
		$args 	= func_get_args();
		$str 	= array_shift($args);
		$format = '/^([0-9]{15}|[0-9]{17}[0-9a-z])$/i';
		$this->trim_blank($str);
		return (preg_match($format,$str)) ? true : false;
	}
	
	//----------------------------------------------------------
	public function email(){
		$args 	= func_get_args();
		$str 	= array_shift($args);
		$format = '/^([a-z0-9\+_\-]+)(\.[a-z0-9\+_\-]+)*@([a-z0-9\-]+\.)+[a-z]{2,6}$/ix';
		$this->trim_blank($str);
		return (preg_match($format, $str)) ? true : false;
	}
	
	//----------------------------------------------------------
	public function field(){
		$args 	= func_get_args();
		$str 	= array_shift($args);
		
		switch (strtolower($args[0])) {
			case 'en':
				$format = "/^[a-zA-Z]+$/";
			break;
			case 'ennum':
				$format = "/^[a-zA-Z0-9]+$/";
			break;
			default:
				$format = "/^[\|\-\_a-zA-Z0-9]+$/";
			break;
		}
		$this->trim_blank($str);
		return (preg_match($format,$str)) ? true : false;
	}
	
	//----------------------------------------------------------
	public function phone(){
		$args 	= func_get_args();
		$str 	= array_shift($args);
		switch (strtolower($args[0])) {
    		case 'int':
    			$format = '/^[0-9]{4}-([0-9]{3}|0[0-9]{3})-[0-9]{7,8}$/';
			default:
				$format = '/^([0-9]{3}|0[0-9]{3})-[0-9]{7,8}$/';
			break;
		}
		$this->trim_blank($str);
		return (preg_match($format,$str)) ? true : false;
	}
	
	//----------------------------------------------------------
	public function string(){
		$args 	= func_get_args();
		$str 	= array_shift($args);
		$args	= $args[0];
		
		$min = $args['min'];
		$max = $args['max'];
        $this->trim_blank($str);
		return ($min <= strlen($str) && strlen($str) <= $max) ? true : false;
	}
	
	//----------------------------------------------------------
    /**
     * 过滤字符串
     *
     *@access   public
     *@param    $str
     *@return   string
     **/  
	public function trim_blank($str) {
		return preg_replace("/\s/","",$str);
	}
}