<?php   if ( ! defined('FIT_PATH')) exit('No direct script access allowed');
/**
 * @copyright 2009 - 2010 Bincent.com. All Rights Reserved.
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @package	FitPHP
 * @subpackage library
 * 
 * @author Hongbin Hsu <Hongbin.Hsu@gmail.com> Initial.
 * @version $Id: image/watermark.php 1.0 2010-09-18 16:52 hongbin.hsu $
 */
 
// ------------------------------------------------------------------------

class Library_Watermark
{
    private $ground_image;			//原图
    private $ground_handle;			//原图标识符
    private $water_image;			//水印图片
    private $water_handle;			//水印标识符
    private $type;					//水印类型（文本或图片）
    private $x;						//X轴位置
    private $y;						//Y轴位置
    private $width;					//宽度
    private $height;				//高度
    private $angle;					//角度
    private $text;					//文本
    private $color;					//颜色
    private $size;					//字体大小
    private $font;					//字休

    //----------------------------------------------------------
	/**
	 * 构造函数
	 *
	 * @param file $ground_image
     * @param int  $posType
	 */
    public function __construct($image = '') {
    	try {
    		if(!function_exists("gd_info")) {
            	throw new Exception('Please open GD2');
	        }
	        if(!file_exists($image)) {
	            throw new Exception('Not find ground_image');
	        }
	        $this->ground_image = $image;
    	}catch (Exception $e){
    		echo $e->getMessage();
    	}
    }

    //----------------------------------------------------------
	/**
	 * 设置水印文本信息
	 *
	 * @param string $text
     * @param string $color
     * @param int $size
     * @param file $font
	 */
    public function set_water_text($text = '', $font = '' ,$color = "#000000", $size = 5) {
        $this->type = 0;
        $this->color = $color;
        $this->text = $text;
        $this->size = $size;
        $this->font = $font;
    }

    //----------------------------------------------------------
	/**
	 * 设置水印图片信息
	 *
	 * @param file $water_image
	 */
    public function set_water_image($image = '') {
    	$this->water_image = $image;
    }
    
    //----------------------------------------------------------
	/**
	 * 设置水印位置
	 *
	 * @return void
	 */
    public function set_water_pos($x, $y, $width, $height, $angle = 0) {
        $this->x = $x;
        $this->y = $y;
        $this->width = $width;
        $this->height = $height;
        $this->angle = $angle;
    }
    
    //----------------------------------------------------------
	/**
	 * 创建加水印的图像
	 *
	 * @return void
	 */
    public function create($ext_file_name = '') {
        $this->ground_handle = $this->get_handle($this->ground_image);
        imagealphablending($this->ground_handle, true);
        if($this->type == 0) {
        	$color = imagecolorallocate($this->ground_handle, hexdec(substr($this->color,1,2)), hexdec(substr($this->color,3,2)), hexdec(substr($this->color,5,2)));
            imagettftext($this->ground_handle, $this->size, $this->angle, $this->x, $this->y, 
            	$color, $this->font, $this->text);
        } else {
            $this->water_handle = $this->get_handle($this->water_image);
            imagecopy($this->ground_handle,$this->water_handle , $this->x, $this->y, 0, 0, $this->width,$this->height);
        }
        $this->out_watered_image($ext_file_name);
        $this->destroy_handle();
    }
    
    //----------------------------------------------------------
	/**
	 *取得图像标识符
	 *
	 * @param int $type
	 * 
	 * @return resource
	 */
    private function get_handle($image){
    	try {
    		switch($this->get_image_type($image)){
	            case 1:
	                $handle = imagecreatefromgif($image);
	                break;
	            case 2:
	                $handle = imagecreatefromjpeg($image);
	                break;
	            case 3:
	                $handle = imagecreatefrompng($image);
	                break;
	            default:
	                throw new Exception('Can not get handle');
	        }
	        return $handle;
    	}catch (Exception $e){
    		echo $e->getMessage();
    	}
    }
    
    //----------------------------------------------------------
	/**
	 * 取得图片信息
	 *
	 * @return array
	 */
    private function get_image_type($image) {
		try {
	    	if(file_exists($image)) {
	            $info = getimagesize($image);
	        } else {
	            throw new Exception('Not find image');
	        }
	        return $info[2];
    	}catch (Exception $e){
    		echo $e->getMessage();
    	}
    }
    
    //----------------------------------------------------------
	/**
	 * 设置输出图像类型
	 *
	 * @return void
	 */
    private function out_watered_image($ext_file_name) {
    	try {
    		switch($this->get_image_type($this->ground_image)) {
	            case 1:
	                imagegif($this->ground_handle, $ext_file_name.$this->ground_image);
	                break;
	            case 2:
	                imagejpeg($this->ground_handle, $ext_file_name.$this->ground_image);
	                break;
	            case 3:
	                imagepng($this->ground_handle, $ext_file_name.$this->ground_image);
	                break;
	            default:
	               throw new Exception('Can not create format');
	        }
    	}catch (Exception $e){
    		echo $e->getMessage();
    	}
    }
	
    //----------------------------------------------------------
	/**
	 * 销毁图像类型
	 *
	 * @return void
	 */
    private function destroy_handle() {
        imagedestroy($this->ground_handle);
        imagedestroy($this->water_handle);
    }
}